// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use super::{DELTA_TIME, sampler::{WhiteNoise, BrownianNoise}, resampler::{Resampler, SmoothstepResampler}};

const AMPLITUDE: f32 = 0.6875;
const TIME: f32 = 0.75;
const FADE_IN: f32 = TIME / 64.0;

pub fn generate() {
	let mut white_noise1 = SmoothstepResampler::new(WhiteNoise::new(471907));
	let mut white_noise2 = SmoothstepResampler::new(WhiteNoise::new(471908));
	let mut white_noise3 = SmoothstepResampler::new(WhiteNoise::new(471909));
	let mut brownian_noise1 = SmoothstepResampler::new(BrownianNoise::new(0.25, 471910));
	let mut brownian_noise2 = SmoothstepResampler::new(BrownianNoise::new(0.5, 471911));

	super::generate("kill", TIME, AMPLITUDE, |t| {
		let fade_out = 1.0 - t / TIME;

		let mut wave = 0.0;
		wave += fade_out.powi(8) * white_noise1.next(8000.0 * DELTA_TIME) * 0.25;
		wave += fade_out.powi(6) * white_noise2.next(4000.0 * DELTA_TIME) * 0.375;
		wave += fade_out.powi(3) * white_noise3.next(1500.0 * DELTA_TIME) * 0.375;
		wave += fade_out.powi(2) * brownian_noise1.next(3000.0 * DELTA_TIME) * 0.125;
		wave += fade_out * brownian_noise2.next(6000.0 * DELTA_TIME) * 0.125;

		let amplitude = 1.0 - (1.0 - (t / FADE_IN).min(1.0)).powi(2); // Fade in
		wave * amplitude
	});
}
