// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::f32::consts::TAU;

use super::waves::Waves;

const AMPLITUDE: f32 = 0.5;
const TIME: f32 = 1.0;
const BASE_FREQ: f32 = 600.0;

pub fn generate() {
	let notes = [
		(BASE_FREQ, 0.0, 0.875),
		(BASE_FREQ * 2.0f32.powf(9.0 / 12.0), 0.125, 1.0),
	];

	super::generate("checkpoint", TIME, AMPLITUDE, |time| {
		let mut wave = 0.0;
		for &(freq, start, end) in &notes {
			let t = time / TIME;
			if t >= start && t <= end {
				let s = (t - start) / (end - start);
				let mut w = 0.0;
				for i in 0..4 {
					w += (time * (freq + i as f32 * s * (6.0 + s * 8.0)) * TAU).smooth_square(0.125) / (i + 1) as f32;
				}
				wave += w * (s * 64.0).min(1.0) * (1.0 - s).powi(4);
			}
		}
		wave
	});
}
