// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::array;

use super::{DELTA_TIME, sampler::WhiteNoise, resampler::{Resampler, SmoothstepResampler}};

const AMPLITUDE: f32 = 0.13125;
const TIME: f32 = 0.125;
const FADE_IN: f32 = TIME / 32.0;

pub fn generate() {
	let mut noises: [SmoothstepResampler<WhiteNoise>; 16] = array::from_fn(|i| SmoothstepResampler::new(WhiteNoise::new(1728749 + i as u64)));

	super::generate("block_bullet", TIME, AMPLITUDE, |t| {
		let mut wave = 0.0;
		for (i, noise) in noises.iter_mut().enumerate() {
			let freq = 1500.0 * (i + 1) as f32 * (1.5 - t / TIME);
			let amplitude = (1.0 - t / TIME).powf(1.5 + i as f32 * 2.0) / (i as f32 + 1.0);
			wave += noise.next(freq * DELTA_TIME) * amplitude;
		}

		let amplitude = 1.0 - (1.0 - (t / FADE_IN).min(1.0)).powi(2); // Fade in
		wave * amplitude
	});
}
