Here's a checklist of my immediate plans for the future. If you have an idea for a feature, feel free to make an issue.

# v1.5.0
* [x] Publish key changes.
	* [x] Constant time equality.
	* [x] Don't log it.
* [x] Prevent panic if sound fails to initialise.
* [x] Create bot players.
	* [x] Create very simple bots.
		* [x] Handle new case where not all players are clients.
		* [x] Have bot players join the game.
		* [x] Basic input control of bot players.
		* [x] Have the player's name be an Option, and make sure bots have no name.
		* [x] Ensure player/client count in discovery data excludes bots.
	* [x] Pathfinding and setting direction.
		* [x] Implement A*.
		* [x] Benchmark A*.
		* [x] Optimise A*.
		* [x] Modify A* to handle edge cases.
			* [x] World size != grid size.
			* [ ] ~Start/goal position is outside of grid.~
				* Unnecessary.
		* [x] Basic path following.
			* [x] Get started.
			* [x] Fix things.
		* [x] Set direction of player to follow the path.
		* [x] Ensure pathfinding fails fast if no such path exists.
			* [x] Also log a warning if failing slow.
		* [x] Limit pathfinding to a maximum distance between the start and goal.
			* This prevents possible denial of service attacks in an infinite (or very large) world with players flying arbitrarily far to execute arbitrarily (after enough time) expensive pathfindings.
		* [x] Prevent pathfinding from getting stuck in case there's an infinite loop until OOM.
			* If my code is perfect this wouldn't happen. But if it's not perfect then the consequences would be severe, completely crashing the entire server process.
			* A good solution is to abort search once the backpointer map is sufficiently large (this limit can be based on the maximum distance to avoid false positives).
		* [x] Add back the benchmarking code.
	* [x] Aiming at other players.
		* [x] Add code to follow a player.
		* [x] Calculate direction required to shoot in to hit the player.
		* [x] Shoot the player if they're sufficiently close.
	* [x] High-level planning.
		* [x] Split current code into two layers of abstraction: the targeting layer and the planning layer.
		* [x] Allow bot players to retreat from some point.
		* [x] Attacking states.
			* [x] Get started.
			* [x] Respond to an initial attack by monitoring the world changes.
		* [x] Movement states.
			* [x] Get started.
			* [x] Collecting.
			* [ ] ~Add constants preparing for later configuration.~
			* [x] Improve things by using fallback movement in case searching for one path fails.
			* [x] Continue following some paths once the endpoint has been reached.
			* [x] Use randomness in deciding when to update the path.
			* [x] Reset paths on death.
	* [x] Improvements.
		* [x] Don't shoot if targeted player is behind a block.
		* [x] Path following.
		* [x] Resolve all relevant TODOs.
		* [x] Look in the opposite direction when retreating and not shooting.
* [x] Resolve most TODOs.
* [x] Further player configuration.
	* [x] Create player config.
	* [x] Add config to `Player` struct.
	* [x] Use these fields rather than constants.
		* [x] Speed.
		* [x] Max health.
		* [x] Regeneration.
		* [x] Bullets.
			* [x] Reload.
				* [x] Get it working.
				* [ ] ~Improve sound effects.~
			* [x] Damage.
			* [x] Speed.
			* [x] Spread.
			* [x] Lifetime.
	* [x] Add default player config to world config.
	* [x] Allow custom player config in `NewPlayer` event.
		* This will be constant for the entire player's lifetime.
	* [x] Remove infinite effect zones from many server configs.
* [x] Custom textures for bot players.
	* [x] Make a simple texture.
	* [x] Add support for multiple textures to the protocol.
	* [x] Use the simple texture for bot players.
	* [x] Improve the texture.
		* [x] Create core.
		* [x] Create circuit.
			* [x] Right.
			* [x] Top.
			* [x] Left.
		* [x] Further decorations.
			* [x] Grid.
			* [x] Edge decorations.
			* [x] Detailed core.
* [x] Resolve all TODOs.
* [x] Create level system.
	* [x] Get a basic level working.
		* [x] Create minimal server code for levels.
			* [x] Get started.
			* [x] Send out world updates, preventing the client from timing out.
		* [x] Basic bot player configuration within the level.
			* [x] Add bots to the game.
			* [x] Create config for bot spawn positions ~and load it from file~.
			* [x] Add fixed spawnpoint.
			* [x] More level configuration.
			* [x] Ensure that all bots are in the same team, and ensure they don't target each other.
			* [x] Allow customising the player configs.
		* [x] Completion and failure.
			* [x] Eliminate bot players once they are killed.
			* [x] Win the game when all bot players have been eliminated, exiting the level.
			* [x] Improve level completion.
			* [x] Add lives to the game, so that the player fails a level if they lose all their lives.
				* [x] Implement lives on the server.
					* [x] Eliminate player on failure.
					* [x] Reset game after failure.
				* [x] Display lives on the client in the top-left corner, instead of the scores.
	* [x] Implement sanity checks and test level restarting.
	* [x] Immediately update camera on level reset.
	* [x] Checkpoints.
		* [x] Functionality.
			* [x] Add them to the configuration and the world.
			* [x] Render them.
			* [x] Implement collision detection *for human players* and activate them.
			* [x] Make them functional.
		* [x] Graphics.
			* [x] Create basic texture.
			* [x] Optimise texture creation.
				* [x] Code improvements.
				* [x] Parallelism.
			* [x] Add colour to texture.
				* [x] Get started.
				* [x] Desaturate edges.
				* [x] Optimise generation.
			* [x] Have active checkpoints stand out compared to regular checkpoints.
			* [x] Animate transition to/from active checkpoint.
			* [ ] ~Improve deactivation animation.~
				* Can be the same.
			* [ ] ~Possibly animate active checkpoint while idle in some way.~
		* [x] Particle effects for active checkpoints.
			* [x] Start creating physics.
			* [x] Start creating colours.
			* [x] Polishes.
		* [x] Sound effect for activating a checkpoint.
			* [x] Create simple sound effect and play that sound.
			* [x] Improvements.
			* [x] Polishes
	* [x] Story text.
		* [x] Create a very simple popup window.
		* [x] Have the level initially be paused until the popup is closed.
			* [x] Get started.
			* [x] Prevent scrolling while paused from having an effect when popup is removed.
			* [x] Prevent looking around.
			* [x] Prevent disconnection when waiting too long.
			* [x] Change cursor in story text.
			* [x] Try hiding HUD while story text is shown.
		* [x] Allow controlling the text on this window through the level config.
		* [x] Improve styling of this popup window.
			* [x] Fully opaque grey border.
			* [x] Partially transparent dark grey background.
			* [x] Mostly white text.
		* [x] UI improvements.
			* [x] Limit window size if text is too long.
			* [x] Implement scrolling.
			* [x] Add button to close popup.
				* [x] Create functional button.
				* [x] Style button.
			* [x] Add dedicated action for closing story text.
	* [x] Implement multiple test levels.
		* [x] Create prototype GUI for story mode.
			* [x] Improve play selection GUI.
			* [x] Create story mode GUI.
			* [x] Add level buttons GUI.
		* [x] Implement multiple levels and add that to the GUI.
			* [x] Refactor code to have the GUI control the server's config.
			* [x] Deserialise and load a single config file.
			* [x] Support multiple levels.
				* [x] Basic implementation.
				* [x] Error handling and async.
				* [x] Prevent directory traversal attacks.
		* [x] Save which levels the player has completed.
			* [x] Add it to the config schema.
			* [x] Update the config when completing a level.
			* [x] Change the button style for completed levels.
			* [x] Allow clearing progress in the GUI.
		* [x] Require completing the previous level before starting the current one, unless an "Unlock all levels" checkbox is ticked.
			* [x] Disable buttons for locked levels.
			* [x] Create "Unlock all levels" checkbox to bypass this.
* [x] Simplify things by having only the server configure sanity checks.
* [x] Add command line option to play a level without opening the GUI.
* [x] Create levels.
	* [x] Level 1.
		* [x] Block map.
		* [x] Improve bot configuration with layers.
		* [x] Story.
	* [x] Fix sound performance problem.
		* [x] Remove looping tracks, cleaning up the code.
		* [x] Use a single track to play the two looping sounds.
		* [x] Configure amplitude and direction to ensure the looping sounds sound the same as before.
			* [x] Replicate spatial sound effects.
			* [x] Average the playback speed for the Doppler effect.
			* [x] Fade in/out.
	* [x] Change ammo system.
		* [x] Preserve ammo after death.
		* [x] Change bot behaviour to avoid seeking ammo crates when initially idle.
		* [x] Spawn ammo crates in levels at specified *deterministic* spots.
		* [x] Add a limit to the number of active ammo crates.
	* [x] Level 2.
		* [x] Block map.
		* [x] Bots.
		* [x] Ammo crates.
		* [x] Story.
	* [x] Level 3.
		* [x] Block map.
		* [x] Path.
			* [x] Update special areas to support arbitrary triangles.
			* [x] Add arrows to server config.
			* [x] Place arrows in the world.
		* [x] Bots.
		* [x] Ammo.
		* [x] Powerups.
		* [x] Story.
	* [x] Level 4.
		* [x] Block map.
		* [x] Bots.
		* [x] Ammo.
		* [x] Powerups.
		* [x] Story.
	* [x] Level 5.
		* [x] Block map.
			* [x] Create frame.
			* [x] Fill in each part.
				* [x] Part 1.
				* [x] Part 2.
				* [x] Part 3.
		* [x] Bots.
		* [x] Ammo.
		* [x] Powerups.
		* [x] Story.
		* [x] Flag.
			* [x] Add flag to config and world.
			* [x] Allow it to be picked up once all bots are destroyed, and change win condition.
			* [x] Add chat message mentioning that the flag must be collected and returned to win, in case the user didn't read the story.
		* [x] Balances.
* [x] Module refactor.
	* [x] Move `blocks` into `world`.
	* [x] Move `net/server` to `server` and `net/server/endpoint` to `net/server`.
	* [x] Decrease size of `net` module.
	* [x] Move `gui`, `game` and `playing` into `app` module.
	* [x] Simplify `world` module.
		* [x] Move rendering code.
		* [x] Move smooth world code.
		* [x] Move specific event handling code to servers.
* [x] Resolve TODOs.
* [x] Think about whether bot players should be able to win the game and update code accordingly if necessary.
	* [ ] ~Update win messages if necessary, doesn't make sense to congratulate bots.~
		* Bot players don't exist in multiplayer, not yet relevant.
* [ ] ~Further possible bot changes.~
	* [ ] ~Intentionally decrease aim accuracy.~
	* [ ] ~Allow random errors.~
	* Not needed.
* [x] Polishes.
* [x] Documentation updates.
* [x] Update SERP Play version.
