window.search = Object.assign(window.search, JSON.parse('{"doc_urls":["introduction.html#introduction","introduction.html#screenshots","introduction.html#links","1-how-to-play.html#how-to-play","1-how-to-play.html#playing-the-game","1-how-to-play.html#controls","1-how-to-play.html#health","1-how-to-play.html#ammo","1-how-to-play.html#powerups","1-how-to-play.html#exiting-a-game","1-how-to-play.html#player-customisation","1-1-singleplayer.html#singleplayer","1-1-singleplayer.html#playing-the-levels","1-1-singleplayer.html#completing-a-level","1-1-singleplayer.html#checkpoints","1-2-multiplayer.html#multiplayer","1-2-multiplayer.html#joining-a-game","1-2-multiplayer.html#teams","1-2-multiplayer.html#winning-the-game","1-2-multiplayer.html#chat","1-2-multiplayer.html#commands","1-2-multiplayer.html#underpowering","1-2-multiplayer.html#security","1-2-multiplayer.html#secure","1-2-multiplayer.html#local","1-2-multiplayer.html#insecure","1-2-multiplayer.html#note-on-eavesdropping","1-2-multiplayer.html#spectator-mode","2-settings.html#settings","2-settings.html#player","2-settings.html#input","2-settings.html#graphics","2-settings.html#sound","2-settings.html#online-servers","2-settings.html#accessibility","3-hosting-a-server.html#hosting-a-game-server","3-hosting-a-server.html#configurations","3-1-gui.html#gui","3-2-command-line.html#command-line","3-2-command-line.html#online-server","3-2-command-line.html#allowing-internet-connections","3-2-command-line.html#connecting-to-the-server","3-2-command-line.html#using-a-tls-certificate","3-2-command-line.html#private-servers","3-2-command-line.html#privacy","3-2-command-line.html#privacy-levels","3-2-command-line.html#setting-the-config","3-2-command-line.html#publishing-a-game-server","3-2-command-line.html#hosting-a-publication-server","4-requesting-server-info.html#requesting-server-info","4-requesting-server-info.html#client-information","5-server-configuration.html#server-configuration","5-server-configuration.html#get-started","5-server-configuration.html#example","5-server-configuration.html#spawning-ammo-crates-and-powerups","5-server-configuration.html#special-areas","5-server-configuration.html#portals","5-server-configuration.html#effect-zones","5-server-configuration.html#teams","5-server-configuration.html#example-3","5-server-configuration.html#custom-spawn-points","5-server-configuration.html#scoring","5-server-configuration.html#examples","5-server-configuration.html#notes","5-server-configuration.html#lobby","5-server-configuration.html#timer","5-server-configuration.html#capture-the-flag","5-server-configuration.html#increasing-the-score","5-server-configuration.html#stability","5-server-configuration.html#advanced-configuration","5-server-configuration.html#tips","6-server-console.html#server-console","6-server-console.html#game-ids","6-server-console.html#private-servers","6-server-console.html#examples","6-server-console.html#multiple-servers","6-server-console.html#hosting-a-private-server"],"index":{"documentStore":{"docInfo":{"0":{"body":26,"breadcrumbs":2,"title":1},"1":{"body":3,"breadcrumbs":2,"title":1},"10":{"body":6,"breadcrumbs":3,"title":2},"11":{"body":43,"breadcrumbs":3,"title":1},"12":{"body":47,"breadcrumbs":4,"title":2},"13":{"body":21,"breadcrumbs":4,"title":2},"14":{"body":14,"breadcrumbs":3,"title":1},"15":{"body":0,"breadcrumbs":3,"title":1},"16":{"body":104,"breadcrumbs":4,"title":2},"17":{"body":44,"breadcrumbs":3,"title":1},"18":{"body":51,"breadcrumbs":4,"title":2},"19":{"body":54,"breadcrumbs":3,"title":1},"2":{"body":26,"breadcrumbs":2,"title":1},"20":{"body":40,"breadcrumbs":3,"title":1},"21":{"body":61,"breadcrumbs":3,"title":1},"22":{"body":77,"breadcrumbs":3,"title":1},"23":{"body":29,"breadcrumbs":3,"title":1},"24":{"body":25,"breadcrumbs":3,"title":1},"25":{"body":58,"breadcrumbs":3,"title":1},"26":{"body":34,"breadcrumbs":4,"title":2},"27":{"body":56,"breadcrumbs":4,"title":2},"28":{"body":9,"breadcrumbs":2,"title":1},"29":{"body":4,"breadcrumbs":2,"title":1},"3":{"body":25,"breadcrumbs":2,"title":1},"30":{"body":81,"breadcrumbs":2,"title":1},"31":{"body":13,"breadcrumbs":2,"title":1},"32":{"body":6,"breadcrumbs":2,"title":1},"33":{"body":13,"breadcrumbs":3,"title":2},"34":{"body":14,"breadcrumbs":2,"title":1},"35":{"body":31,"breadcrumbs":5,"title":3},"36":{"body":43,"breadcrumbs":3,"title":1},"37":{"body":84,"breadcrumbs":4,"title":1},"38":{"body":92,"breadcrumbs":6,"title":2},"39":{"body":66,"breadcrumbs":6,"title":2},"4":{"body":16,"breadcrumbs":3,"title":2},"40":{"body":77,"breadcrumbs":7,"title":3},"41":{"body":86,"breadcrumbs":6,"title":2},"42":{"body":79,"breadcrumbs":7,"title":3},"43":{"body":14,"breadcrumbs":6,"title":2},"44":{"body":37,"breadcrumbs":5,"title":1},"45":{"body":38,"breadcrumbs":6,"title":2},"46":{"body":60,"breadcrumbs":6,"title":2},"47":{"body":100,"breadcrumbs":7,"title":3},"48":{"body":24,"breadcrumbs":7,"title":3},"49":{"body":34,"breadcrumbs":6,"title":3},"5":{"body":59,"breadcrumbs":2,"title":1},"50":{"body":11,"breadcrumbs":5,"title":2},"51":{"body":34,"breadcrumbs":4,"title":2},"52":{"body":46,"breadcrumbs":3,"title":1},"53":{"body":113,"breadcrumbs":3,"title":1},"54":{"body":10,"breadcrumbs":6,"title":4},"55":{"body":67,"breadcrumbs":4,"title":2},"56":{"body":114,"breadcrumbs":3,"title":1},"57":{"body":35,"breadcrumbs":4,"title":2},"58":{"body":8,"breadcrumbs":3,"title":1},"59":{"body":21,"breadcrumbs":3,"title":1},"6":{"body":22,"breadcrumbs":2,"title":1},"60":{"body":21,"breadcrumbs":5,"title":3},"61":{"body":63,"breadcrumbs":3,"title":1},"62":{"body":200,"breadcrumbs":3,"title":1},"63":{"body":82,"breadcrumbs":3,"title":1},"64":{"body":58,"breadcrumbs":3,"title":1},"65":{"body":49,"breadcrumbs":3,"title":1},"66":{"body":124,"breadcrumbs":4,"title":2},"67":{"body":39,"breadcrumbs":4,"title":2},"68":{"body":13,"breadcrumbs":3,"title":1},"69":{"body":102,"breadcrumbs":4,"title":2},"7":{"body":22,"breadcrumbs":2,"title":1},"70":{"body":38,"breadcrumbs":3,"title":1},"71":{"body":49,"breadcrumbs":4,"title":2},"72":{"body":97,"breadcrumbs":4,"title":2},"73":{"body":63,"breadcrumbs":4,"title":2},"74":{"body":11,"breadcrumbs":3,"title":1},"75":{"body":38,"breadcrumbs":4,"title":2},"76":{"body":30,"breadcrumbs":5,"title":3},"8":{"body":85,"breadcrumbs":2,"title":1},"9":{"body":4,"breadcrumbs":3,"title":2}},"docs":{"0":{"body":"Here’s the documentation for Spaceships v1.5.0. Right now this documentation is pretty incomplete. If you have any questions, ask them on Lemmy or Matrix, whichever you prefer. More information about Lemmy and Matrix is available here: Lemmy: https://join-lemmy.org/ Matrix: https://matrix.org/","breadcrumbs":"Introduction » Introduction","id":"0","title":"Introduction"},"1":{"body":"Here are some screenshots of the game:","breadcrumbs":"Introduction » Screenshots","id":"1","title":"Screenshots"},"10":{"body":"The name and colour of the player can be changed by going into the settings.","breadcrumbs":"How to play » Player customisation","id":"10","title":"Player customisation"},"11":{"body":"Right now singleplayer exists in the form of a story mode, consisting of five levels of increasing difficulty. The story in this game is that you are an insurgent fighter in a military operation to recover the private key and liberate all consumer computing devices by unlocking their bootloaders and allowing installation of a custom freedom-respecting operating system. At the beginning of each level you will be presented a message from your commander about the current status of the operation.","breadcrumbs":"How to play » Singleplayer » Singleplayer","id":"11","title":"Singleplayer"},"12":{"body":"To play a level, first click the “Play” button on the title screen and then click “Story Mode” under “Singleplayer”. Then click any one of the five level buttons to play a level. By default, you need to complete the levels in order and so levels that you cannot play because you haven’t completed the previous level are greyed out. If you want to disable this feature and play any level you want to, enable the “Unlock All Levels” checkbox. There also is a button available to reset your progress.","breadcrumbs":"How to play » Singleplayer » Playing the levels","id":"12","title":"Playing the levels"},"13":{"body":"To complete a level you need to navigate the map and kill all bot players. While playing the level you have a finite number of lives, which you lose when you get killed. If you lose all your lives you lose the level and need to restart.","breadcrumbs":"How to play » Singleplayer » Completing a level","id":"13","title":"Completing a level"},"14":{"body":"A feature that exists in levels but doesn’t exist in multiplayer servers is checkpoints. When you reach a checkpoint, you will respawn at that location whenever you get killed.","breadcrumbs":"How to play » Singleplayer » Checkpoints","id":"14","title":"Checkpoints"},"15":{"body":"","breadcrumbs":"How to play » Multiplayer » Multiplayer","id":"15","title":"Multiplayer"},"16":{"body":"To play a multiplayer game, first click the “Play” button on the title screen. The next step depends on if the server is hosted on the internet or on the local network. If the game server is available online, click “Online” and then “Search” to view a list of public online servers. Then click “Play” on the particular server you want to join. If the game server is hosted on the local network, click “Local” and then click “Search LAN” and if everything works well, the game server will pop up and you can then click “Play”. Sometimes you might need to manually enter the address. This can be if the server is hosted on the local network and the above instructions don’t work for some reason (maybe a host or network firewall), or if the server’s online but not publicly visible. In that case, click “Enter Address” and enter the IP address or domain name in the “Host” section, and then click “Play”. The default settings for “Port” and “Game ID” don’t need to be changed unless the server administrator mentions setting them to a particular value.","breadcrumbs":"How to play » Multiplayer » Joining a game","id":"16","title":"Joining a game"},"17":{"body":"Some Spaceships servers can have teams enabled. When you join the game, you will be assigned to a specific team. To change teams, first list the available teams by running the command ( keep reading for information about commands) teams. This should return a list of teams on the server. Then run team NAME where NAME is the name of the team you want to change to. When in a team, your bullets cannot hit other members of your team (unless the server has friendly fire enabled).","breadcrumbs":"How to play » Multiplayer » Teams","id":"17","title":"Teams"},"18":{"body":"The way the game is actually won, if there is a way, is highly customisable. On the top-left corner of the screen is a list of scores that the server keeps track of. These scores can increase or decrease when certain events happen, such as when a player gets a kill or kills someone else. Here is a list of a few examples of win conditions that are possible: First to N kills. Most kills within a certain amount of time. Last player remaining where players are eliminated if they lose too many lives.","breadcrumbs":"How to play » Multiplayer » Winning the game","id":"18","title":"Winning the game"},"19":{"body":"Spaceships has two types of in-game chat that you can use to talk to other players. The first type is team chat which allows you to talk to your team members. To open team chat, press ‘T’ (you can bind this to something different), start typing and press enter to send your message. Only other players on your team will receive your message, unless teams are disabled in which all players will receive the message. The second type of chat is global chat which lets you talk to all players. Opening global chat is done by pressing ‘G’.","breadcrumbs":"How to play » Multiplayer » Chat","id":"19","title":"Chat"},"2":{"body":"Website: https://spaceships.me Download: https://spaceships.me/download Documentation: https://spaceships.me/docs Source code: https://codeberg.org/rustydev/spaceships Lemmy: https://lemmy.spaceships.me Development blog: https://lemmy.spaceships.me/c/blog Help and support: https://lemmy.spaceships.me/c/help Matrix: #spaceships:matrix.spaceships.me Chat: #chat:matrix.spaceships.me Help and support: #help:matrix.spaceships.me PeerTube: https://peertube.spaceships.me","breadcrumbs":"Introduction » Links","id":"2","title":"Links"},"20":{"body":"Spaceships also supports sending commands to the server using the chat window. To send a command, first press ‘/’ (again, can be rebinded), type your command and then press enter to send it. Run the help command to get an exact list of commands the server supports. Note that opening chat and typing a message beginning with ‘/’ won’t execute a command and instead send a regular message.","breadcrumbs":"How to play » Multiplayer » Commands","id":"20","title":"Commands"},"21":{"body":"If you’re an experienced player playing with a friend who is new to the game, you can choose to make yourself weaker to make the game fairer. This is called underpowering and is done by executing commands. For an example, to decrease your speed to 75% of what it usually is, run underpower speed 75%. Note that you can use 0.75 instead of 75%, and the alias up can be used. Another example is to completely disable regeneration, you can run up regen 0. The general syntax for this specific subcommand is underpower/up EFFECT VALUE, where EFFECT is speed, reload, regen (or regeneration) and damage, and value is a number or a percentage.","breadcrumbs":"How to play » Multiplayer » Underpowering","id":"21","title":"Underpowering"},"22":{"body":"If you’re playing this game online, you might be concerned about whether encryption is used, especially when it comes to chat messages which might be sensitive. Spaceships uses QUIC, a transport-layer protocol over UDP that always uses encryption. However, that doesn’t mean that all communications are secure. First note that the security I’m referring to here is about whether a malicious device on the path between the client and the server can eavesdrop communications. All chat messages are logged for the server owner to read, so if you don’t trust the server owner, don’t send any sensitive chat messages. While playing the game, the connection’s security is displayed in the bottom-left corner when the chat window is open. This information is one of the three security levels, “Secure”, “Local” and “Insecure”.","breadcrumbs":"How to play » Multiplayer » Security","id":"22","title":"Security"},"23":{"body":"If a connection is secure, as indicated by the green text saying “Secure connection”, it is very unlikely that communication is being eavesdropped. This level of security is reached when the server is hosted on the same device, or a trusted TLS certificate is used. This level of security is the same as HTTPS on the web.","breadcrumbs":"How to play » Multiplayer » Secure","id":"23","title":"Secure"},"24":{"body":"If a connection is local, as indicated by the blue text saying “Local connection”, it means that the connection isn’t secure, but can only be eavesdropped by an attacker on the local network. If you’re connecting to a server on the local network and you trust that network, communications are secure.","breadcrumbs":"How to play » Multiplayer » Local","id":"24","title":"Local"},"25":{"body":"If a connection is insecure, as indicated by the red text saying “INSECURE connection!”, it means that the connection isn’t secure and can be eavesdropped by an attacker on the internet that controls a node on the path. This attacker can be an ISP or a government agency. For most users, it is unlikely that there actually is an attacker listening into communications, but it is still possible. If you live in an authoritarian regime such as Russia, Saudi Arabia, Myanmar, the United States, Israel, China, Iran or the United Kingdom, you shouldn’t send any chat messages that the government would disapprove of if using an insecure connection. It’s better to be safe than sorry.","breadcrumbs":"How to play » Multiplayer » Insecure","id":"25","title":"Insecure"},"26":{"body":"I mentioned earlier that encryption is always enabled in Spaceships. That is true but it is still possible to eavesdrop by performing a man-in-the-middle attack in which an attacker impersonates the server and can decrypt communications. This encryption is still better than nothing as it fully prevents against passive eavesdropping attacks, where the attacker can only listen in but can’t modify the messages.","breadcrumbs":"How to play » Multiplayer » Note on eavesdropping","id":"26","title":"Note on eavesdropping"},"27":{"body":"If you want to watch a game play out but not be an active player, you can join as a spectator. To do this, click the checkbox before starting the game or execute the spectate command while playing the game. While in spectator mode, you can move the camera around using WASD or the arrow keys and you can also drag the camera using the mouse. You can also press ‘F’ to toggle between freely moving around and following another player in the world. Some game modes can eliminate the player before the game ends, in which those players will be forcefully put into spectator mode.","breadcrumbs":"How to play » Multiplayer » Spectator mode","id":"27","title":"Spectator mode"},"28":{"body":"In the title screen, you can click “Settings” to change some settings related to input and graphics.","breadcrumbs":"Settings » Settings","id":"28","title":"Settings"},"29":{"body":"Here you can change your name and colour.","breadcrumbs":"Settings » Player","id":"29","title":"Player"},"3":{"body":"There are two ways of playing Spaceships: singleplayer and multiplayer. Multiplayer has existed since the game’s creation while a functional singleplayer has only very recently been implemented, being new to v1.5.0. This page will discuss gameplay that is common to both singleplayer and multiplayer.","breadcrumbs":"How to play » How to play","id":"3","title":"How to play"},"30":{"body":"The second part of the settings screen provides a way to change the keyboard and mouse button bindings to certain actions. These actions are organised into many categories available as headers, such as “UI” and “Player”. Click on these to open up a list of buttons for each action in that category. You can then hover over a button to get a list of inputs bound to that action. For example, hovering over the “Open Chat” button shows “Bound to: Key T”. To change these bindings, first click on one of these buttons after which a window will pop up showing the bound inputs and three buttons. To add a binding, first click “Select” and then press any key or click any mouse button. Now you can click “Bind” to bind the recently performed input to that action. You can do the same for unbinding.","breadcrumbs":"Settings » Input","id":"30","title":"Input"},"31":{"body":"The graphics part of the settings screen allows you to change the decorative sky background, which particle effects are enabled and more.","breadcrumbs":"Settings » Graphics","id":"31","title":"Graphics"},"32":{"body":"Here you can change the volume of the game’s sound effects.","breadcrumbs":"Settings » Sound","id":"32","title":"Sound"},"33":{"body":"When you browse the list of online servers, a request is made to some server that maintains this list. By default this server is game.spaceships.me, but you can change this.","breadcrumbs":"Settings » Online Servers","id":"33","title":"Online Servers"},"34":{"body":"Here you can make the text larger by increasing the UI scaling factor, and choose to have labels above powerups which can help for colourblindness.","breadcrumbs":"Settings » Accessibility","id":"34","title":"Accessibility"},"35":{"body":"There are two ways of hosting a server, using the GUI and with the command line. The GUI for creating a server provides only the basic functionality for creating game servers playable on the local network. For more advanced functionality like having the server accessible from the internet, you need to use the command line.","breadcrumbs":"Hosting a server » Hosting a game server","id":"35","title":"Hosting a game server"},"36":{"body":"To get started you first need to know the basics of game server configurations. A server configuration, or config specifies many different aspects to how a game is played, including but not limited to the block map, the rate at which items (powerups and ammo crates) spawn, the scoring system and how you win the game. Spaceships by default includes many different configurations in the configs/ directory, each of which focus on a particular feature.","breadcrumbs":"Hosting a server » Configurations","id":"36","title":"Configurations"},"37":{"body":"To get started, from the title screen click the “Play” button and then under the “Create” subsection, click the “Local” button. Now select your desired configuration from the drop-down menu and click the “Create” button that pops up. These configs are listed in the configs/ directory for the standalone distribution, or for Flatpak in both /app/config/ and $XDG_DATA_HOME/spaceships/configs ( ~/.var/app/me.spaceships.spaceships/data/spaceships/configs/ outside of the sandbox), with the latter directory being writable. If you add or change a config, click “Refresh Servers” to reload this list of servers. Now if everything goes well, the server has been created. You can join the server by clicking “Play” 1 and stop the server by clicking “Stop Server”. Instructions are also included for how players can join the game by manually entering the address, if searching the local network doesn’t work for some reason. You can also access it by searching the local network. ↩","breadcrumbs":"Hosting a server » GUI » GUI","id":"37","title":"GUI"},"38":{"body":"To get started, simply run ./spaceships server configs/survival.ron. 1 This starts a game of survival, where each player has five lives and the winner is the last player alive. In this command, configs/survival.ron is the path to the game’s configuration. If you’re using Flatpak, the default configuration files are instead located in /app/configs/ inside the sandbox. The server program outputs logs to the terminal (in particular, stderr), which include information about players joining and leaving the game. If you want to save these logs and if your server is publicly accessible, I strongly recommend not directly writing to a file ( spaceships server ... 2> out.log). Doing so can expose you to a certain type of denial-of-service attack where an attacker might be able to completely fill up your storage with logs. I created a tool that allows you to save logs in a way that mitigates this attack. The server also provides a simple REPL interface which allows more advanced configuration.","breadcrumbs":"Hosting a server » Command line » Command line","id":"38","title":"Command line"},"39":{"body":"By default the server can only be joined from the local network. If you want your server to be available online, you need to perform a few more steps. First you need to configure the Spaceships server to accept connections from the internet, which by default are prohibited. To do this, add -P global to the command line arguments which changes the privacy settings. The next steps after this are to allow incoming connections from the internet to actually reach the server. What you will need to do isn’t unique to Spaceships, these steps are necessary if you want to have any server accessible on the internet, whether that is another game server or a website. Knowing this, other guides for hosting servers such as this guide for Luanti will also work for Spaceships.","breadcrumbs":"Hosting a server » Command line » Online server","id":"39","title":"Online server"},"4":{"body":"Gameplay in Spaceships involves the player controlling a spaceship that they move around and kill other spaceships by firing bullets at them to diminish their health and eventually destroy them.","breadcrumbs":"How to play » Playing the game","id":"4","title":"Playing the game"},"40":{"body":"In some cases, you won’t need to do anything! 2 One option is to have the server hosted on your machine or another machine in your home. To do this, you need to set up port forwarding on your router (and possibly update any firewall configuration), which is mapping a port on the public IP address seen by the internet to a port on a private IP address of the machine you’re hosting the server. Spaceships uses UDP port 4080 by default, so make sure the port on the private IP address also is 4080. The port associated with the public IP address can be anything, but 4080 is recommended (as this port will already be filled in when connecting by manually entering the address). Another option is to use a VPS, which you might need to use if you’re unlucky enough to be behind a CGNAT.","breadcrumbs":"Hosting a server » Command line » Allowing internet connections","id":"40","title":"Allowing internet connections"},"41":{"body":"To test if the server is available online, you need to try connecting to it with the public IP address. If you’re using port forwarding, the public IP address can be found by searching “what is my ip” into your preferred search engine and clicking one of the results. If you’re using a VPS, you should already know this. Joining the game over the internet is done by clicking the “Enter Address” button in the playing screen and manually entering this public IP address (as well as the port if the default of 4080 isn’t used). If you don’t want players to manually enter an address, keep reading. If you’re using port forwarding, the public IP address might be dynamic and so would change over time. This would require users to periodically change the entered IP address, or dynamic DNS can be used with users instead entering a hostname.","breadcrumbs":"Hosting a server » Command line » Connecting to the server","id":"41","title":"Connecting to the server"},"42":{"body":"If you’re running an online server with an associated domain name, if users want to connect to the server by entering the domain name you will need a valid TLS (also called SSL) certificate. To run the server to use this certificate, run ./spaceships ... --cert-path PATH --key-path PATH, replacing PATH with the paths of the certificate and private key in PEM format. Updating the certificate without restarting the server can be done with the cert command in the server console. See spaceships-cert-status for a tool that can be used by a script to create reminders before the certificate expires. Automatic updating of certificates isn’t yet supported, though if you really wanted to, you could automatically write the cert command into the server’s standard input to execute the command.","breadcrumbs":"Hosting a server » Command line » Using a TLS certificate","id":"42","title":"Using a TLS certificate"},"43":{"body":"Once you’ve created an online server, anyone on the internet can connect to it. If you want to limit this to only those with a password, see these instructions.","breadcrumbs":"Hosting a server » Command line » Private servers","id":"43","title":"Private servers"},"44":{"body":"Spaceships allows restricting which clients can discover and join each game server. These privacy settings are called discoverability and joinability. Each privacy setting can be set to a privacy level, which can be none, loopback, local or global in order from most to least restrictive. By default both discoverability and joinability are set to local, which blocks connections from outside the local network.","breadcrumbs":"Hosting a server » Command line » Privacy","id":"44","title":"Privacy"},"45":{"body":"Here’s an explanation on each of the four privacy levels for whether clients are allowed to discover/join the server: none: No clients are allowed. loopback: Only clients on the same host are allowed. local: Only clients on the local network are allowed. global: All clients are allowed. Note that this doesn’t automatically allow players on the internet to connect to the game, see the above instructions to do this.","breadcrumbs":"Hosting a server » Command line » Privacy levels","id":"45","title":"Privacy levels"},"46":{"body":"To set the default privacy config for game servers, add --privacy or -P with the given privacy config. This is either a single privacy level (to configure both to the same level) or multiple in the form of discoverability/joinability. Here are two examples: -P global disables all restrictions for players joining and discovering the server. -P none/local prevents all clients from discovering servers and limits clients on the local network to joining a server. Note that the joinability cannot be more restrictive than the discoverability. This prevents players from seeing a game when browsing online or local servers but not being able to join it.","breadcrumbs":"Hosting a server » Command line » Setting the config","id":"46","title":"Setting the config"},"47":{"body":"If you want your game server to be available online and included on the public list of online servers, you need to publish it to a publication server. This is done by adding --publish ADDRESS to the command line arguments, replacing “ADDRESS” with game.spaceships.me (the default public server list) or the address of another publication server. To change the port of this publication server, add --publish-port PORT to the command line arguments. If you’re using a TLS certificate, it is highly recommended to also add --server-name NAME to the command line arguments so that players connect with the given hostname and so can obtain a secure connection. When publishing, all game servers that are discoverable by the publication server are published, meaning having global discovery (or less if the discovery server is on the local network). If servers get added or removed using the server console, this information gets automatically published to the publication server. If the connection with the publication server is ever lost, the publishing server periodically attempts to reconnect to it.","breadcrumbs":"Hosting a server » Command line » Publishing a game server","id":"47","title":"Publishing a game server"},"48":{"body":"If you want to host a server that accepts these publications from other servers, you can do this by simply adding --accept-publications to the command line arguments. On Windows, you would run ./spaceships.exe server .... ↩ This can happen if you’re on a network that doesn’t have any NAT or firewall in the way. ↩","breadcrumbs":"Hosting a server » Command line » Hosting a publication server","id":"48","title":"Hosting a publication server"},"49":{"body":"This game is licensed under the GNU AGPLv3, which requires that any user interacting with the game over the network can get a copy of the exact version of the game running on the server. If you want to know the exact version of a server and if it’s a fork, run ./spaceships info HOST, where HOST is the domain name or IP address of the server.","breadcrumbs":"Requesting server info » Requesting server info","id":"49","title":"Requesting server info"},"5":{"body":"To move around, use WASD or the arrow keys. To change the direction you’re looking in and where bullets will be fired from, move the mouse. Bullets are shot by pressing the left mouse button or spacebar. You can hold down these buttons to easily fire multiple bullets at a time. These controls can be changed by pressing the “Settings” button while in the title screen. You can zoom the camera in and out by scrolling (or by pressing ‘J’ and ‘K’), and you can reset to the default zoom by pressing the middle mouse button. If you’re playing a game that has flags and you have captured one, you can drop it by pressing ‘Q’.","breadcrumbs":"How to play » Controls","id":"5","title":"Controls"},"50":{"body":"The information about your version of Spaceships can be obtained by running ./spaceships info or clicking the “About” button in the title screen.","breadcrumbs":"Requesting server info » Client information","id":"50","title":"Client information"},"51":{"body":"The long-term goal of Spaceships is to support configuration of everything in the game, including the physics, weapons, and other objects, similar to how games like Luanti currently are. Right now Spaceships isn’t there yet, but game servers are pretty configurable. If you find any errors in this documentation, which are likely if I forget to update this in future versions, make an issue here.","breadcrumbs":"Server configuration » Server configuration","id":"51","title":"Server configuration"},"52":{"body":"The documentation here is incomplete. I recommend first taking a look at files in the configs/ directory attached with your distribution of the game, or at https://codeberg.org/rustydev/spaceships/src/branch/main/configs for examples of what a config file looks like. These can be used as a template for creating your own server config. These configuration files are in the RON (Rusty Object Notation) format. See the link for more information. The complete schema of the config files is available inside src/net/server/config.rs, with some (but not enough) code comments explaining things.","breadcrumbs":"Server configuration » Get started","id":"52","title":"Get started"},"53":{"body":"Here’s an example of a very simple configuration file that’s a large world with no blocks in it. This is available at configs/empty.ron. ( world: ( size: (inf, inf), ), discovery: ( name: \\"Empty\\", desc: \\"An empty map.\\", ), blocks: ( block_size: 1, grid_size: (0, 0), ops: [ Constant(0) ], ),\\n) Now here’s an explanation of each of these fields: world.size: This specifies the width and height of the world. Players cannot go outside this space. In this example, both the width and height are set to inf which configures the largest possible world (not actually infinite). discovery: This specifies the name and description of the game server shown in search results for online and local servers. blocks: This consists of three fields, each for configuring the physical blocks in the world that constrain the players’ movement. blocks.block_size: This is an integer that sets how large each block is in the game. blocks.grid_size: This sets the width and height of the grid which contains these blocks. The number of blocks in this grid cannot exceed 2 20. blocks.ops: This specifies a list of operations that are performed on block maps stored on a stack to produce a final block map.","breadcrumbs":"Server configuration » Example","id":"53","title":"Example"},"54":{"body":"To configure these, see the fields with the events prefix. See the full schema for more information.","breadcrumbs":"Server configuration » Spawning, ammo crates and powerups","id":"54","title":"Spawning, ammo crates and powerups"},"55":{"body":"The server has the ability to send an arbitrary list of rectangles of arbitrary position, size and colour to the clients, which the clients should render these in the world. These are designed for highlighting regions of the world where custom server-side configuration can perform certain actions. Right now the two special areas implemented in this game are portals and effect zones, though more special areas can be added in the future and those special areas can still be compatible with older clients. Here’s an example of how to add special areas that are just decorative: ( ... special_areas: ( areas: [ ( pos: (15, 15), size: (4, 4), colour: (127, 255, 0, 63) ) ], ),\\n)","breadcrumbs":"Server configuration » Special areas","id":"55","title":"Special areas"},"56":{"body":"Portals allow players (but not bullets) to teleport from one location to another. Portals can either be sinks (you enter these), sources (you leave these), or bidirectional (you can go both ways). Portals are expressed in the config as a directed graph, with nodes being the portals and edges being the possible transitions between portals. If a node has more than one outgoing edge, players entering that portal will teleport to a random outgoing neighbour of that portal. It is a desirable feature to allow the velocity of players to change after they leave the portal, like if they entered a horizontal portal and leave a vertical portal. To do this, special_areas.portals.out.rotation can be set to either D0 (default for no rotation), D90, D180 or D270. When specifying portals, make sure that the player isn’t inside a block or outside the world border if they are at the portal’s centre. If you don’t ensure this, it might be possible for players to teleport inside a block. Example ( ... special_areas: ( portals: [ ( rect: ((-4.5, -3.0), (1.5, 0.5)), out: [ ( index: 1, rotation: D90), ( index: 2 ), ], ), ( rect: ((12.5, -9.5), (14.5, -1.5)) ), ( rect: ((22, 22), (24, 23)), out: [( index: 0 )], ), ], ),\\n)","breadcrumbs":"Server configuration » Portals","id":"56","title":"Portals"},"57":{"body":"An effect zone is a region where players get effects applied to them (the same effects that powerups give) while there. These effects can persist for an arbitrary amount of time when the player leaves the effect zone. Example ( ... special_areas: ( effect_zones: [ ( rect: ((15, 15), (19, 19)), effect: Speed, time: 5, power: 4, // Very fast! ), ] ),\\n)","breadcrumbs":"Server configuration » Effect zones","id":"57","title":"Effect zones"},"58":{"body":"By default teams are disabled. To enable them, you need to specifically add them to the config.","breadcrumbs":"Server configuration » Teams","id":"58","title":"Teams"},"59":{"body":"Here is an example of how to create a red and blue team. ( ... teams: [ ( name: \\"Red\\", colour: \\"red\\", aliases: [\\"r\\", \\"red\\"], ), ( name: \\"Blue\\", colour: \\"blue\\", aliases: [\\"b\\", \\"blue\\"], ), ],\\n)","breadcrumbs":"Server configuration » Example","id":"59","title":"Example"},"6":{"body":"Your health is displayed in the health bar at the bottom of your screen, with the number of bullets also displayed above that. The health bars of other players are displayed right above them. After getting shot, players slowly regenerate their health.","breadcrumbs":"How to play » Health","id":"6","title":"Health"},"60":{"body":"It is possible to have all players in a team spawn at a fixed location in the world by adding spawn_point: Some((X, Y)) for some X and Y. This doesn’t affect player spawning when in the lobby. See configs/occupation.ron for an example of this.","breadcrumbs":"Server configuration » Custom spawn points","id":"60","title":"Custom spawn points"},"61":{"body":"The scoring part of the config schema consists of two parts: the controller and the conditions for winning and elimination. The score controller specifies how the player and team scores should change in response to events, like a player getting a kill, dying or occupying a part of the world (see the occupation game). The win and elimination conditions accept as input the scores of either the player or the teams, as well as the timer. These decide respectively when the game should end and who (either in terms of players or teams) should win the game, or who should be removed from the game until the game finishes. By default there is no win or elimination condition and the score of each player is their kill count.","breadcrumbs":"Server configuration » Scoring","id":"61","title":"Scoring"},"62":{"body":"Here are a few examples of how the scoring system can be configured. First to 10 kills To win the game in the following config, you need to be the first player to get at least 10 kills. It should be noted that multiple players can win the game if they both get to at least 10 kills at the exact same time, though this is very unlikely to occur. ( ... scoring: ( win: Player(FirstTo((GreaterEqual, 10))), ),\\n) Survival Here’s another config where each player starts off with five lives, and the winning player is the last player remaining. Players get eliminated when they lose all their lives, as shown in the elimination condition. The full config is in configs/survival.ron. ( ... scoring: ( controller: ( events: [ ( listener: Death, score: -1, ), ], player: ( init: 5, ), ), win: Player(LastWith((Greater, 0))), elimination: Player(FirstTo((LessEqual, 0))), can_join_midgame: false, ),\\n) Occupation Here is a server config that provides a unique game mode that isn’t around killing the other players or staying alive. Instead, the game consists of two teams, red and blue, that spawn at fixed locations in their base. When you occupy the base of the other team, your team’s score increases. The winner is the team with the highest score after five minutes. If after five minutes the scores are tied, the first team to then increase their score wins. (Also when occupying the other team’s base, you can teleport back to your own base with the team-only portal.) This config also involves the timer which is displayed on the top-right corner of the screen and is used in the win condition. The full config is in configs/occupation.ron. ( ... scoring: ( controller: ( events: [ ( listener: Occupation(( owner: 0, rect: ((-10, -30), (10, -25.5)), capture_time: 1, period: 0.2, )), score: 1, output: Team, ), ( listener: Occupation(( owner: 1, rect: ((-10, 25.5), (10, 30)), capture_time: 1, period: 0.2, )), score: 1, output: Team, ), ], ), win: Team(And([ Extremum( type: Maximum, exclusive: true ), Timer((LessEqual, 0)), ])), ), ... timer: ( now: 300, limit: 0, counting: Down, ),\\n)","breadcrumbs":"Server configuration » Examples","id":"62","title":"Examples"},"63":{"body":"When making your own scoring system and conditions for winning and elimination, here are a few important notes to consider: Avoid Equal as a comparison operator. If having a goal of the winning player being the first one to 20 kills, you probably don’t want to use goal: FirstTo((Equal, 20)). This is because it’s possible that a player has 19 kills, and then fires two bullets which kill two players at the exact same time and boost their score to 21. In that case, that player lost their chance of winning the game. Prevent players from joining mid-game. If your scoring system involves the elimination of players, you should add can_join_midgame: false to the config to prevent players from joining after being eliminated. You should also do this if players joining the game later on have an advantage (like having much fewer deaths).","breadcrumbs":"Server configuration » Notes","id":"63","title":"Notes"},"64":{"body":"By default as soon as players join, the game starts. However, you can put players in a “lobby” where players can shoot and kill each other but scoring is disabled before the game starts. This can be done to give players a break after playing the game. To enable the lobby and have it last for, say 60 seconds, add this to your config: ( ... lobby: ( time: 60, ),\\n) Players can start the game prematurely if they all are ready by running the ready command (or its alias of r). If you want to decrease the proportion of players that need to be ready before the game starts, change ready_threshold to a value in [0, 1].","breadcrumbs":"Server configuration » Lobby","id":"64","title":"Lobby"},"65":{"body":"A timer can be added while playing the game which can provide useful information to players, such as when the game will end. This timer can be used in the scoring system for the win and elimination conditions. Here is an example of a timer that starts at zero and counts up forever. This timer is configured to display the raw seconds and use millisecond precision (which is probably overkill). By default there is no timer. ( ... timer: ( now: 0, limit: inf, counting: Up, precision: Milli, format: S, ),\\n)","breadcrumbs":"Server configuration » Timer","id":"65","title":"Timer"},"66":{"body":"Here is an example of a capture the flag configuration. This is a teamed game where players can capture flags from other teams and bring those flags to their own team’s base. The full config is in configs/ctf.ron. ( ... flags: [ ( default_pos: (-6, -28), team: 0 ), ( default_pos: (0, -28), team: 0 ), ( default_pos: (6, -28), team: 0 ), ( default_pos: (-6, 28), team: 1 ), ( default_pos: (0, 28), team: 1 ), ( default_pos: (6, 28), team: 1 ), ], teams: [ ( name: \\"Red\\", colour: \\"red\\", aliases: [\\"r\\", \\"red\\"], spawn_point: (0, -27.5), base: ( rect: ((-12, -30), (12, -25.5)) ), ), ( name: \\"Blue\\", colour: \\"blue\\", aliases: [\\"b\\", \\"blue\\"], spawn_point: (0, 27.5), base: ( rect: ((-12, 25.5), (12, 30)) ), ), ],\\n) Here, default_pos is the starting position of the flag and team is the id (indexing the teams array below) of the flag’s team. Also in the teams defined below is the team’s base. Flags are returned to their default position if they collide with their team’s base (and aren’t being picked up by a player on the other team), and they emit score events (for the base’s team) when a flag is returned to another team’s base.","breadcrumbs":"Server configuration » Capture the flag","id":"66","title":"Capture the flag"},"67":{"body":"Here is an example of how to increase the team’s score by one whenever a flag is returned to that team’s base. Here Flag(None) increases the score for all flags returned. If you want different flags to be worth different scores, instead use Flag(Some(i)) to only increase the score for the flag of index i being returned. ( ... scoring: ( controller: ( events: [ ( listener: Flag(None), score: 1, ), ], ), ),\\n)","breadcrumbs":"Server configuration » Increasing the score","id":"67","title":"Increasing the score"},"68":{"body":"I make no guarantees about the stability of this schema between versions, even to changes in the patch version (third number in the version).","breadcrumbs":"Server configuration » Stability","id":"68","title":"Stability"},"69":{"body":"Everything that can be configured right now through the server config is just a small sample of what you can actually configure. If you want to add something like an effect zone but for giving players ammo, it’s possible to modify the server source code without needing all players to update their game to your specific fork. Here’s a list of ideas that can be implemented for custom server-side configuration that unmodified clients can play with: Recoil: When players fire bullets, the server can decrease the player’s velocity by a small amount in the opposite direction of the fired bullet. Stealing ammo: When a player kills another player, an ammo crate might spawn containing all ammo that player had. Player-player collision: Right now the game’s physics don’t support collision between players. However, this functionality can be hacked on by the server arbitrarily controlling the players’ positions and velocities. Even more advanced configuration would require forking the game, such as if you want to add a new type of weapon.","breadcrumbs":"Server configuration » Advanced configuration","id":"69","title":"Advanced configuration"},"7":{"body":"You have a finite amount of bullets (unless the server is configured to provide you infinite), which are reset when you die. Periodically during the game, ammo crates are spawned which supply the player collecting them with a random amount of bullets.","breadcrumbs":"How to play » Ammo","id":"7","title":"Ammo"},"70":{"body":"Here are some tips to be more efficient when customising a game server: Right-click to print position. When in the world, you can right-click (or whatever you choose to bind it to) and the position your cursor’s pointing at will be printed to stderr. This can be very helpful when placing special effects. reload command. In the server console, you can run reload default to quickly restart the server, which you might do a lot.","breadcrumbs":"Server configuration » Tips","id":"70","title":"Tips"},"71":{"body":"When starting the server, you have access to a console that allows addition and removal of game servers, without restarting the entire process. Complete documentation for these particular commands isn’t provided here but instead available by running help in this console. Instead what is documented here is game ids and basic usage of running multiple game servers on the same process. When using this console, I recommend redirecting stderr to somewhere else to avoid the logs from distracting you as you write your commands.","breadcrumbs":"Server console » Server console","id":"71","title":"Server console"},"72":{"body":"A Spaceships server can run multiple different game servers on the same UDP port. When a player joins the game, the client includes a game id in the request it makes to the server to play the game. The server then takes this id and checks its “routing table” to find a game server the player can join. Game ids are either entered manually when manually entering the address, or automatically with online or local discovery. The exact mapping of game ids to game servers is up to the server. Game servers are limited to having only one game id, and game ids are limited to being at most 64 bytes. One game server can be configured to be the default, if it has game id “default”. Here, if the user entered a game id that doesn’t match any explicit rule in the routing table, the player will join this default server. When you start a server without specifying a game id, it will be configured to be the default server.","breadcrumbs":"Server console » Game ids","id":"72","title":"Game ids"},"73":{"body":"Game ids can be used to have the server accessible over the internet but restrict who can join the game by requiring users enter a password. Here, the game id is the password. This works because clients cannot access to this routing table. To ensure that a game server is truly private, it must not be globally discoverable! This is the case in the default settings but not if you run the server with -P global. One way to prevent this and still have the game publicly joinable is to add -P none/global instead. To verify this privacy setting, run the status command which prints out information of all running game servers, including the privacy config.","breadcrumbs":"Server console » Private servers","id":"73","title":"Private servers"},"74":{"body":"Here are some examples. Lines beginning with $ indicate a shell, while lines beginning with > indicate the server console.","breadcrumbs":"Server console » Examples","id":"74","title":"Examples"},"75":{"body":"Here is an example of how to host multiple game servers on the same process. $ ./spaceships server maze:configs/maze.ron\\n> add cave:configs/cave.ron\\n> add white_noise:configs/white_noise.ron\\n> rename white_noise noise\\n> add configs/empty.ron After running all of this, the game ids maze, cave and noise are mapped to the servers with configs configs/maze.ron, configs/cave.ron and configs/white_noise.ron respectively, and all other game ids are mapped to configs/empty.ron by default.","breadcrumbs":"Server console » Multiple servers","id":"75","title":"Multiple servers"},"76":{"body":"Here is how to run just a single server only accessible through a hard to guess game id. $ ./spaceships server -P none/global I-L0v3_sP4c35h1p5:configs/private.ron Make sure that no colons are present in the password. If not, the game id would end there and the remainder of the string would be the path of a config file that most likely doesn’t exist.","breadcrumbs":"Server console » Hosting a private server","id":"76","title":"Hosting a private server"},"8":{"body":"Additionally, powerups are periodically spawned which give the player collecting them a temporary effect. These effects either last for 30 seconds or happen immediately (teleportation) and are listed as follows: Speed. This is the green powerup which increases your movement speed. Reload. This is the yellow powerup which increases your reload speed, making you shoot faster. Health. This is the pink powerup which increases your health and makes you regenerate health faster. The increase of health that this powerup provides can increase your health above the usual limit and make your health bar blue. Damage. This is the red powerup which increases the damage of your bullets. Forcefield. This is the blue powerup which provides a forcefield that deflects bullets fired by other players. Teleportation. This is the purple powerup which teleports you to a random place on the map. Unlike the others, this can be disadvantageous depending where you teleport… Here are these six powerups:","breadcrumbs":"How to play » Powerups","id":"8","title":"Powerups"},"9":{"body":"To exit the game, press escape.","breadcrumbs":"How to play » Exiting a game","id":"9","title":"Exiting a game"}},"length":77,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{"2":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"56":{"tf":1.0}}},"7":{"5":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"21":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":2.23606797749979},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":2.6457513110645907}}},"1":{".":{"5":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"0":{"df":1,"docs":{"62":{"tf":2.8284271247461903}}},"2":{".":{"5":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"7":{"df":1,"docs":{"55":{"tf":1.0}}},"df":1,"docs":{"66":{"tf":2.0}}},"4":{".":{"5":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":2,"docs":{"55":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951}}},"9":{"df":2,"docs":{"57":{"tf":1.4142135623730951},"63":{"tf":1.0}}},"df":8,"docs":{"37":{"tf":1.0},"38":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":2.449489742783178},"64":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.0}}},"2":{"0":{"df":2,"docs":{"53":{"tf":1.0},"63":{"tf":1.4142135623730951}}},"1":{"df":1,"docs":{"63":{"tf":1.0}}},"2":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"56":{"tf":1.0}}},"4":{"df":1,"docs":{"56":{"tf":1.0}}},"5":{".":{"5":{"df":2,"docs":{"62":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"5":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"7":{".":{"5":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":1,"docs":{"66":{"tf":2.449489742783178}}},"df":4,"docs":{"38":{"tf":1.0},"40":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0}}},"3":{".":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"0":{"0":{"df":1,"docs":{"62":{"tf":1.0}}},"df":3,"docs":{"62":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"df":0,"docs":{}},"4":{".":{"5":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"0":{"8":{"0":{"df":2,"docs":{"40":{"tf":1.7320508075688772},"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"55":{"tf":1.4142135623730951},"57":{"tf":1.0}}},"5":{"df":2,"docs":{"57":{"tf":1.0},"62":{"tf":1.0}}},"6":{"0":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"55":{"tf":1.0}}},"4":{"df":1,"docs":{"72":{"tf":1.0}}},"df":1,"docs":{"66":{"tf":2.0}}},"7":{"5":{"df":1,"docs":{"21":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"9":{".":{"5":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":5,"docs":{"16":{"tf":1.0},"34":{"tf":1.0},"45":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"39":{"tf":1.0},"48":{"tf":1.4142135623730951},"61":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":8,"docs":{"34":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"76":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"30":{"tf":2.23606797749979},"55":{"tf":1.0}}}},"v":{"df":1,"docs":{"27":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"18":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":1.0},"53":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":12,"docs":{"30":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"55":{"tf":1.0},"58":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":7,"docs":{"16":{"tf":1.7320508075688772},"37":{"tf":1.0},"40":{"tf":2.23606797749979},"41":{"tf":2.6457513110645907},"47":{"tf":1.7320508075688772},"49":{"tf":1.0},"72":{"tf":1.0}}}}}}},"df":5,"docs":{"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"35":{"tf":1.0},"38":{"tf":1.0},"69":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"3":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"i":{"a":{"df":2,"docs":{"21":{"tf":1.0},"64":{"tf":1.0}},"s":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"v":{"df":2,"docs":{"38":{"tf":1.0},"62":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":10,"docs":{"11":{"tf":1.0},"19":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":2.449489742783178},"56":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"22":{"tf":1.0},"26":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":4,"docs":{"36":{"tf":1.0},"54":{"tf":1.0},"69":{"tf":2.0},"7":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"18":{"tf":1.0},"57":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":9,"docs":{"21":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"47":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}},"p":{"df":0,"docs":{},"p":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"37":{"tf":1.0},"38":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"r":{"a":{"b":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"55":{"tf":1.4142135623730951},"57":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"55":{"tf":2.449489742783178}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"39":{"tf":1.0},"47":{"tf":1.7320508075688772},"48":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"27":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"27":{"tf":1.0},"5":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"0":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"40":{"tf":1.0},"42":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"52":{"tf":1.0}}},"k":{"df":4,"docs":{"24":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":2.0},"38":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"42":{"tf":1.4142135623730951},"45":{"tf":1.0},"47":{"tf":1.0},"72":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":11,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"63":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"62":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"r":{"df":2,"docs":{"6":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"62":{"tf":2.0},"66":{"tf":2.449489742783178},"67":{"tf":1.0}},"’":{"df":1,"docs":{"66":{"tf":1.0}}}},"i":{"c":{"df":3,"docs":{"35":{"tf":1.0},"36":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}}},"df":2,"docs":{"59":{"tf":1.0},"66":{"tf":1.0}},"e":{"df":9,"docs":{"23":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":1.0},"46":{"tf":1.0},"56":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"27":{"tf":1.4142135623730951},"42":{"tf":1.0},"64":{"tf":1.4142135623730951}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"11":{"tf":1.0},"20":{"tf":1.0},"74":{"tf":1.4142135623730951}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"25":{"tf":1.0},"26":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"22":{"tf":1.0},"27":{"tf":1.0},"56":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0}}}}}}}},"i":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"19":{"tf":1.0},"30":{"tf":2.23606797749979},"70":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":4,"docs":{"36":{"tf":1.0},"44":{"tf":1.0},"53":{"tf":3.0},"56":{"tf":1.4142135623730951}},"s":{".":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"s":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"_":{"df":0,"docs":{},"s":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"2":{"tf":1.0}}}},"u":{"df":0,"docs":{},"e":{"df":5,"docs":{"24":{"tf":1.0},"59":{"tf":2.0},"62":{"tf":1.0},"66":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"13":{"tf":1.0}},"h":{"df":7,"docs":{"3":{"tf":1.0},"37":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"22":{"tf":1.0},"6":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"66":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":2,"docs":{"33":{"tf":1.0},"46":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":9,"docs":{"17":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.7320508075688772},"56":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"12":{"tf":1.7320508075688772},"16":{"tf":1.0},"30":{"tf":2.6457513110645907},"37":{"tf":1.7320508075688772},"41":{"tf":1.0},"5":{"tf":2.0},"50":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"21":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"5":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"62":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"5":{"tf":1.0},"66":{"tf":1.7320508075688772}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"e":{"df":4,"docs":{"16":{"tf":1.0},"40":{"tf":1.0},"63":{"tf":1.0},"73":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}}}}},"v":{"df":0,"docs":{},"e":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"/":{"c":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"18":{"tf":1.4142135623730951},"30":{"tf":1.0},"38":{"tf":1.0},"55":{"tf":1.0}}}}},"df":1,"docs":{"42":{"tf":2.0}},"i":{"df":0,"docs":{},"f":{"df":3,"docs":{"23":{"tf":1.0},"42":{"tf":2.6457513110645907},"47":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":18,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.4142135623730951},"56":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0}}}},"t":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":6,"docs":{"19":{"tf":2.6457513110645907},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":2.0},"25":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":2,"docs":{"12":{"tf":1.0},"27":{"tf":1.0}}}}},"df":1,"docs":{"72":{"tf":1.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"a":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":3,"docs":{"21":{"tf":1.0},"34":{"tf":1.0},"70":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":9,"docs":{"12":{"tf":1.7320508075688772},"16":{"tf":2.8284271247461903},"27":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":2.23606797749979},"37":{"tf":2.449489742783178},"41":{"tf":1.4142135623730951},"50":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"22":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":2.23606797749979},"46":{"tf":1.4142135623730951},"50":{"tf":1.0},"55":{"tf":1.7320508075688772},"69":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":3,"docs":{"2":{"tf":1.0},"52":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"d":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.0}}},"u":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":5,"docs":{"10":{"tf":1.0},"29":{"tf":1.0},"55":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"22":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":15,"docs":{"11":{"tf":1.0},"17":{"tf":1.4142135623730951},"20":{"tf":2.6457513110645907},"21":{"tf":1.0},"27":{"tf":1.0},"35":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"42":{"tf":1.7320508075688772},"47":{"tf":1.7320508075688772},"48":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":5,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"21":{"tf":1.0},"38":{"tf":1.0},"52":{"tf":1.0},"71":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"18":{"tf":1.0},"61":{"tf":1.7320508075688772},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":15,"docs":{"36":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"52":{"tf":2.0},"56":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":2.449489742783178},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}},"s":{"/":{"c":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"53":{"tf":1.0},"75":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"60":{"tf":1.0},"62":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"38":{"tf":1.4142135623730951},"62":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":17,"docs":{"36":{"tf":2.0},"37":{"tf":1.0},"38":{"tf":1.7320508075688772},"39":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.0},"51":{"tf":1.7320508075688772},"52":{"tf":1.0},"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":2.23606797749979},"7":{"tf":1.0},"72":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":11,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":2.0},"25":{"tf":2.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"53":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"42":{"tf":1.0},"47":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":2.0},"74":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"0":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"11":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"53":{"tf":1.0},"69":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":7,"docs":{"25":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"18":{"tf":1.0},"22":{"tf":1.0},"62":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"61":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"36":{"tf":1.0},"54":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"35":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772},"38":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"51":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"’":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":4,"docs":{"11":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":3,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"70":{"tf":1.0}}}}}}}}}},"d":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"1":{"8":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"7":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"0":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"21":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"62":{"tf":1.0},"63":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"31":{"tf":1.0},"55":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":4,"docs":{"18":{"tf":1.0},"21":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"66":{"tf":2.6457513110645907}}}}},"df":22,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":2.0},"73":{"tf":1.0},"75":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"16":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"c":{"df":1,"docs":{"53":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}},"r":{"df":2,"docs":{"37":{"tf":1.0},"56":{"tf":1.0}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"i":{"c":{"df":3,"docs":{"11":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"19":{"tf":1.0},"36":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"72":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"5":{"tf":1.0},"56":{"tf":1.0},"69":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"38":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"52":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"12":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"46":{"tf":1.0},"58":{"tf":1.0},"64":{"tf":1.0}}}},"d":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"25":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"44":{"tf":1.0},"46":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"44":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"73":{"tf":1.0}},"i":{"df":3,"docs":{"47":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"72":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":4,"docs":{"22":{"tf":1.0},"6":{"tf":1.7320508075688772},"62":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":1.0},"52":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"n":{"df":1,"docs":{"41":{"tf":1.0}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.4142135623730951},"2":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}}}}},"df":1,"docs":{"38":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":8,"docs":{"14":{"tf":1.0},"22":{"tf":1.0},"37":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"16":{"tf":1.0},"42":{"tf":1.4142135623730951},"49":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":6,"docs":{"19":{"tf":1.0},"21":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"64":{"tf":1.0}}},"’":{"df":0,"docs":{},"t":{"df":6,"docs":{"16":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"41":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"37":{"tf":1.0},"5":{"tf":1.0},"62":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"37":{"tf":1.0},"5":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}}},"y":{"df":1,"docs":{"61":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":10,"docs":{"11":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"53":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":5,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"df":8,"docs":{"21":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":2.6457513110645907},"69":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"18":{"tf":1.0},"27":{"tf":1.0},"61":{"tf":1.7320508075688772},"62":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772},"65":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"26":{"tf":1.0},"31":{"tf":1.0},"58":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951}}}}}}},"d":{"df":4,"docs":{"27":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"40":{"tf":1.0},"52":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"56":{"tf":1.0},"73":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"16":{"tf":1.7320508075688772},"19":{"tf":1.0},"20":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.23606797749979},"42":{"tf":1.0},"56":{"tf":1.7320508075688772},"72":{"tf":1.7320508075688772},"73":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}},"t":{"df":6,"docs":{"18":{"tf":1.0},"54":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.0}},"u":{"df":1,"docs":{"4":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"16":{"tf":1.0},"37":{"tf":1.0},"51":{"tf":1.0},"69":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"20":{"tf":1.0},"49":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0},"72":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":17,"docs":{"18":{"tf":1.0},"21":{"tf":1.4142135623730951},"30":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.7320508075688772},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"53":{"tf":1.0}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"20":{"tf":1.0},"21":{"tf":1.0},"27":{"tf":1.0},"42":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"14":{"tf":1.4142135623730951},"3":{"tf":1.0},"76":{"tf":1.0}}}},"t":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}},"n":{"df":2,"docs":{"45":{"tf":1.0},"53":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"38":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}}},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"62":{"tf":1.0},"63":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"27":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"36":{"tf":1.0},"56":{"tf":1.0}}}}}},"df":0,"docs":{},"w":{"df":4,"docs":{"18":{"tf":1.0},"39":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"53":{"tf":1.4142135623730951},"54":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":4,"docs":{"38":{"tf":1.4142135623730951},"52":{"tf":2.0},"53":{"tf":1.0},"76":{"tf":1.0}}},"l":{"df":2,"docs":{"38":{"tf":1.0},"40":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"53":{"tf":1.0}}}},"d":{"df":2,"docs":{"51":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"61":{"tf":1.0}}}},"t":{"df":2,"docs":{"13":{"tf":1.0},"7":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":6,"docs":{"17":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.4142135623730951},"63":{"tf":1.0},"69":{"tf":1.4142135623730951},"8":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"16":{"tf":1.0},"40":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":13,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"30":{"tf":1.4142135623730951},"36":{"tf":1.0},"39":{"tf":1.0},"52":{"tf":1.0},"62":{"tf":1.7320508075688772},"63":{"tf":1.0}},"t":{"df":0,"docs":{},"o":{"(":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"v":{"df":0,"docs":{},"e":{"df":4,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"38":{"tf":1.0},"62":{"tf":1.7320508075688772}}}},"x":{"df":2,"docs":{"60":{"tf":1.0},"62":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"5":{"tf":1.0},"66":{"tf":2.8284271247461903},"67":{"tf":2.0}},"’":{"df":1,"docs":{"66":{"tf":1.0}}}},"t":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"37":{"tf":1.0},"38":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"27":{"tf":1.0},"62":{"tf":1.0},"8":{"tf":1.0}}}}}},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"65":{"tf":1.0}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}},"k":{"df":2,"docs":{"49":{"tf":1.0},"69":{"tf":1.4142135623730951}}},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"42":{"tf":1.0},"52":{"tf":1.0},"65":{"tf":1.0}}}},"df":2,"docs":{"11":{"tf":1.0},"46":{"tf":1.0}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"45":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"21":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"54":{"tf":1.0},"62":{"tf":1.4142135623730951},"66":{"tf":1.0}},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"3":{"tf":1.0},"35":{"tf":1.4142135623730951},"69":{"tf":1.0}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"51":{"tf":1.0},"55":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"df":2,"docs":{"33":{"tf":1.0},"47":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":41,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":2.449489742783178},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"27":{"tf":2.23606797749979},"35":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772},"49":{"tf":1.7320508075688772},"5":{"tf":1.0},"51":{"tf":1.7320508075688772},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":1.0},"61":{"tf":2.23606797749979},"62":{"tf":2.0},"63":{"tf":1.7320508075688772},"64":{"tf":2.23606797749979},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":4.0},"73":{"tf":2.449489742783178},"75":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}}},"’":{"df":4,"docs":{"3":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.0},"69":{"tf":1.0}}}}}},"df":1,"docs":{"19":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}},"t":{"df":4,"docs":{"18":{"tf":1.0},"47":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":4,"docs":{"57":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0},"8":{"tf":1.0}},"n":{"df":2,"docs":{"46":{"tf":1.0},"47":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"19":{"tf":1.4142135623730951},"39":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"73":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"49":{"tf":1.0}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"51":{"tf":1.0},"63":{"tf":1.4142135623730951}}}},"df":3,"docs":{"10":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0}},"e":{"df":1,"docs":{"37":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"56":{"tf":1.0}},"i":{"c":{"df":2,"docs":{"28":{"tf":1.0},"31":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"8":{"tf":1.0}}}},"y":{"df":1,"docs":{"12":{"tf":1.0}}}},"i":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":1,"docs":{"53":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}},"i":{"d":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":2,"docs":{"35":{"tf":1.4142135623730951},"37":{"tf":1.0}}}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"18":{"tf":1.0},"48":{"tf":1.0},"8":{"tf":1.0}}}}}},"r":{"d":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":4,"docs":{"35":{"tf":1.0},"47":{"tf":1.0},"63":{"tf":1.4142135623730951},"72":{"tf":1.0}},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"4":{"tf":1.0},"6":{"tf":2.23606797749979},"8":{"tf":2.449489742783178}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.7320508075688772}}}}}},"l":{"df":0,"docs":{},"p":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":5,"docs":{"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"34":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":24,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"18":{"tf":1.0},"22":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"46":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0}},"’":{"df":6,"docs":{"0":{"tf":1.0},"45":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":1.0},"62":{"tf":1.0},"69":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"18":{"tf":1.0},"47":{"tf":1.0}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}}},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":10,"docs":{"16":{"tf":2.23606797749979},"23":{"tf":1.0},"35":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"41":{"tf":1.0},"47":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":1,"docs":{"23":{"tf":1.0}},"s":{":":{"/":{"/":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}},"e":{"/":{"c":{"/":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}},"e":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"d":{"df":7,"docs":{"16":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":3.1622776601683795},"73":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}},"e":{"a":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"3":{"tf":1.0},"55":{"tf":1.0},"69":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":7,"docs":{"36":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"52":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":6,"docs":{"11":{"tf":1.0},"18":{"tf":1.0},"34":{"tf":1.0},"62":{"tf":1.4142135623730951},"67":{"tf":2.0},"8":{"tf":2.449489742783178}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":3,"docs":{"56":{"tf":1.7320508075688772},"66":{"tf":1.0},"67":{"tf":1.0}}}},"i":{"c":{"df":4,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"74":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":2,"docs":{"53":{"tf":1.7320508075688772},"65":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"53":{"tf":1.0},"7":{"tf":1.0}}}}}},"o":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"50":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":10,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"22":{"tf":1.0},"38":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.0},"65":{"tf":1.0},"73":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"28":{"tf":1.0},"30":{"tf":2.0},"42":{"tf":1.0},"61":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"22":{"tf":1.0},"25":{"tf":2.0}}}}},"df":0,"docs":{}},"i":{"d":{"df":3,"docs":{"38":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":8,"docs":{"20":{"tf":1.0},"21":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"62":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"16":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"53":{"tf":1.0}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":9,"docs":{"16":{"tf":1.0},"25":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.7320508075688772},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"73":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":3,"docs":{"4":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0}}}}}}},"p":{"df":4,"docs":{"16":{"tf":1.0},"40":{"tf":2.0},"41":{"tf":2.449489742783178},"49":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":9,"docs":{"24":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0},"71":{"tf":1.0}}}}},"p":{"df":1,"docs":{"25":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"51":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"36":{"tf":1.0}}}},"’":{"df":4,"docs":{"25":{"tf":1.0},"49":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.0}}}},"’":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}},"j":{"df":1,"docs":{"5":{"tf":1.0}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"44":{"tf":1.4142135623730951},"46":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}},"df":13,"docs":{"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"27":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772},"64":{"tf":1.0},"72":{"tf":1.7320508075688772},"73":{"tf":1.0}}}}}},"k":{"df":1,"docs":{"5":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":3,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"41":{"tf":1.0}}}},"y":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":5,"docs":{"11":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"5":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":9,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"18":{"tf":2.0},"4":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":2.0},"63":{"tf":1.7320508075688772},"64":{"tf":1.0},"69":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"36":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"49":{"tf":1.0}}}}}},"l":{"0":{"df":0,"docs":{},"v":{"3":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"4":{"c":{"3":{"5":{"df":0,"docs":{},"h":{"1":{"df":0,"docs":{},"p":{"5":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"53":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"18":{"tf":1.0},"38":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"v":{"df":3,"docs":{"38":{"tf":1.0},"56":{"tf":1.7320508075688772},"57":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":3,"docs":{"18":{"tf":1.0},"22":{"tf":1.0},"5":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.7320508075688772},"2":{"tf":1.0}}},"y":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"47":{"tf":1.0}}}},"t":{"df":1,"docs":{"19":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":9,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":3.0},"13":{"tf":2.0},"14":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951}}}}}},"i":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"36":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"72":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":6,"docs":{"35":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"47":{"tf":1.7320508075688772},"48":{"tf":1.0},"74":{"tf":1.4142135623730951}}},"k":{"df":2,"docs":{"2":{"tf":1.0},"52":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":12,"docs":{"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"20":{"tf":1.0},"30":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"53":{"tf":1.0},"55":{"tf":1.0},"69":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"62":{"tf":1.7320508075688772},"67":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":5,"docs":{"13":{"tf":1.4142135623730951},"18":{"tf":1.0},"25":{"tf":1.0},"38":{"tf":1.0},"62":{"tf":1.4142135623730951}}}}},"o":{"b":{"b":{"df":0,"docs":{},"i":{"df":2,"docs":{"60":{"tf":1.0},"64":{"tf":2.0}}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":12,"docs":{"16":{"tf":2.0},"22":{"tf":1.0},"24":{"tf":2.23606797749979},"35":{"tf":1.0},"37":{"tf":1.7320508075688772},"39":{"tf":1.0},"44":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"53":{"tf":1.0},"72":{"tf":1.0}}},"t":{"df":5,"docs":{"14":{"tf":1.0},"38":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":3,"docs":{"22":{"tf":1.0},"38":{"tf":2.0},"71":{"tf":1.0}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"51":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"5":{"tf":1.0},"52":{"tf":1.4142135623730951}}},"p":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"44":{"tf":1.0},"45":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"13":{"tf":1.7320508075688772},"18":{"tf":1.0},"62":{"tf":1.0}}},"t":{"df":2,"docs":{"47":{"tf":1.0},"63":{"tf":1.0}}}},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"39":{"tf":1.0},"51":{"tf":1.0}}}}}},"df":0,"docs":{}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.7320508075688772}}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"e":{"df":10,"docs":{"21":{"tf":1.4142135623730951},"34":{"tf":1.0},"40":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"26":{"tf":1.0}},"i":{"df":3,"docs":{"18":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.4142135623730951}}},"u":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"16":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"p":{"df":7,"docs":{"13":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"53":{"tf":1.7320508075688772},"72":{"tf":1.0},"75":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"0":{"tf":1.7320508075688772},"2":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"y":{"b":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"e":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":4,"docs":{"22":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"47":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"19":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"16":{"tf":1.0},"26":{"tf":1.0}}}}}},"u":{"df":1,"docs":{"37":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":6,"docs":{"11":{"tf":1.0},"19":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":2,"docs":{"26":{"tf":1.0},"5":{"tf":1.0}}}},"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":4,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"27":{"tf":2.0},"62":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"26":{"tf":1.0},"69":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":12,"docs":{"0":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"27":{"tf":1.0},"30":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772}}}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"27":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"53":{"tf":1.0},"8":{"tf":1.0}}}}}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":4,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"3":{"tf":1.7320508075688772}}}},"df":6,"docs":{"46":{"tf":1.0},"5":{"tf":1.0},"62":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.4142135623730951}}}}}}}},"y":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":10,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"29":{"tf":1.0},"42":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"49":{"tf":1.0},"53":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"48":{"tf":1.0}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":1,"docs":{"18":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":14,"docs":{"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.7320508075688772},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":11,"docs":{"16":{"tf":2.0},"24":{"tf":1.7320508075688772},"35":{"tf":1.0},"37":{"tf":1.4142135623730951},"39":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0}}}}}}},"w":{"df":3,"docs":{"21":{"tf":1.0},"3":{"tf":1.0},"69":{"tf":1.0}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"25":{"tf":1.0},"56":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"df":2,"docs":{"73":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}},"df":2,"docs":{"44":{"tf":1.0},"45":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":8,"docs":{"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.4142135623730951}}},"h":{"df":1,"docs":{"26":{"tf":1.0}}}},"w":{"df":10,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.4142135623730951},"51":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"13":{"tf":1.0},"21":{"tf":1.0},"53":{"tf":1.0},"6":{"tf":1.0},"68":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"51":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"47":{"tf":1.0},"50":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"61":{"tf":1.0},"62":{"tf":1.7320508075688772}},"i":{"df":2,"docs":{"61":{"tf":1.0},"62":{"tf":1.4142135623730951}}}},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"c":{"df":1,"docs":{"43":{"tf":1.0}}},"df":11,"docs":{"12":{"tf":1.0},"22":{"tf":1.0},"30":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.4142135623730951},"63":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":11,"docs":{"16":{"tf":2.0},"22":{"tf":1.0},"33":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"53":{"tf":1.0},"72":{"tf":1.0}}}}}},"p":{"df":1,"docs":{"53":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"22":{"tf":1.0},"30":{"tf":1.4142135623730951}}},"r":{"df":3,"docs":{"11":{"tf":1.7320508075688772},"53":{"tf":1.0},"63":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"44":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":5,"docs":{"12":{"tf":1.0},"27":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.4142135623730951},"73":{"tf":1.0}},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"62":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"37":{"tf":1.0},"44":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"22":{"tf":1.0},"30":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"49":{"tf":1.0},"73":{"tf":1.0}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}}}}}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"22":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951}}}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"3":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"31":{"tf":1.0},"61":{"tf":1.7320508075688772}},"i":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"16":{"tf":1.4142135623730951},"36":{"tf":1.0},"38":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"26":{"tf":1.0}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"43":{"tf":1.0},"73":{"tf":1.4142135623730951},"76":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":5,"docs":{"22":{"tf":1.0},"25":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":2.449489742783178},"76":{"tf":1.0}}}}},"df":4,"docs":{"39":{"tf":1.0},"46":{"tf":1.7320508075688772},"73":{"tf":1.4142135623730951},"76":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}}},"m":{"df":1,"docs":{"42":{"tf":1.0}}},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":5,"docs":{"26":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"o":{"d":{"df":5,"docs":{"41":{"tf":1.0},"47":{"tf":1.0},"62":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}},"h":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"51":{"tf":1.0},"53":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"70":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"y":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":16,"docs":{"12":{"tf":2.449489742783178},"13":{"tf":1.0},"16":{"tf":2.23606797749979},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"4":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"(":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":30,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"18":{"tf":1.7320508075688772},"19":{"tf":2.0},"21":{"tf":1.0},"27":{"tf":2.0},"29":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.7320508075688772},"4":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"53":{"tf":1.4142135623730951},"56":{"tf":2.23606797749979},"57":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":2.23606797749979},"62":{"tf":2.8284271247461903},"63":{"tf":2.8284271247461903},"64":{"tf":2.449489742783178},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":3.1622776601683795},"7":{"tf":1.0},"72":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951}},"’":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":1,"docs":{"55":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"70":{"tf":1.0}}}}},"p":{"df":3,"docs":{"16":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.0}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"55":{"tf":1.0},"56":{"tf":3.605551275463989},"62":{"tf":1.0}},"’":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":5,"docs":{"16":{"tf":1.0},"40":{"tf":2.6457513110645907},"41":{"tf":1.7320508075688772},"47":{"tf":1.7320508075688772},"72":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"55":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":9,"docs":{"18":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"40":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.4142135623730951},"60":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":5,"docs":{"34":{"tf":1.0},"36":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"8":{"tf":3.1622776601683795}}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"41":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"54":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"76":{"tf":1.0}}}}},"s":{"df":6,"docs":{"19":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"27":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":2.23606797749979},"9":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"51":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"26":{"tf":1.0},"46":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"73":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"73":{"tf":1.0}}}},"v":{"a":{"c":{"df":0,"docs":{},"i":{"df":5,"docs":{"39":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.4142135623730951},"46":{"tf":2.0},"73":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"df":6,"docs":{"11":{"tf":1.0},"40":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"73":{"tf":1.4142135623730951},"76":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"63":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"71":{"tf":1.4142135623730951},"75":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":8,"docs":{"30":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":5,"docs":{"16":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":2.0},"47":{"tf":2.8284271247461903},"48":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"16":{"tf":1.0},"38":{"tf":1.0},"73":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"47":{"tf":2.8284271247461903}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}},"t":{"df":2,"docs":{"27":{"tf":1.0},"64":{"tf":1.0}}}}},"q":{"df":1,"docs":{"5":{"tf":1.0}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"i":{"c":{"df":1,"docs":{"22":{"tf":1.0}},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"56":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.0}}}},"w":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":3,"docs":{"59":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"14":{"tf":1.0},"23":{"tf":1.0},"39":{"tf":1.0}}}},"d":{"df":3,"docs":{"17":{"tf":1.0},"22":{"tf":1.0},"41":{"tf":1.0}},"i":{"df":1,"docs":{"64":{"tf":1.7320508075688772}}},"y":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"42":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"16":{"tf":1.0},"37":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"30":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"38":{"tf":1.0},"40":{"tf":1.0},"47":{"tf":1.0},"52":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":1,"docs":{"11":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":4,"docs":{"56":{"tf":1.7320508075688772},"57":{"tf":1.0},"62":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}},"d":{"df":5,"docs":{"25":{"tf":1.0},"59":{"tf":2.0},"62":{"tf":1.0},"66":{"tf":1.7320508075688772},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"21":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"25":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"55":{"tf":1.0},"57":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"o":{"a":{"d":{"df":4,"docs":{"21":{"tf":1.0},"37":{"tf":1.0},"70":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"76":{"tf":1.0}}},"df":2,"docs":{"18":{"tf":1.0},"62":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"47":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"75":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":2,"docs":{"42":{"tf":1.0},"47":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"38":{"tf":1.0}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"33":{"tf":1.0},"49":{"tf":1.0},"72":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":4,"docs":{"41":{"tf":1.0},"49":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"61":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.0},"42":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"44":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"73":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"41":{"tf":1.0},"53":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"17":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":8,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"51":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.0},"62":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"72":{"tf":1.4142135623730951},"73":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"72":{"tf":1.0}}}},"n":{"df":15,"docs":{"17":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"38":{"tf":1.0},"42":{"tf":1.7320508075688772},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.7320508075688772},"75":{"tf":1.0},"76":{"tf":1.0}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"25":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":10,"docs":{"23":{"tf":1.4142135623730951},"30":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"57":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.0}}}}},"n":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":2,"docs":{"37":{"tf":1.0},"38":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}},"y":{"df":3,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":4,"docs":{"52":{"tf":1.0},"54":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":9,"docs":{"18":{"tf":1.4142135623730951},"36":{"tf":1.0},"61":{"tf":2.449489742783178},"62":{"tf":3.3166247903554},"63":{"tf":1.7320508075688772},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":2.6457513110645907}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":12,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"6":{"tf":1.0},"62":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":1,"docs":{"65":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"16":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"53":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"19":{"tf":1.0},"30":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"22":{"tf":2.449489742783178},"23":{"tf":2.23606797749979},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"47":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":8,"docs":{"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.0}},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.0},"37":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"df":5,"docs":{"19":{"tf":1.0},"20":{"tf":2.0},"22":{"tf":1.0},"25":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":39,"docs":{"14":{"tf":1.0},"16":{"tf":2.8284271247461903},"17":{"tf":1.7320508075688772},"18":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"33":{"tf":2.0},"35":{"tf":2.23606797749979},"36":{"tf":1.4142135623730951},"37":{"tf":2.449489742783178},"38":{"tf":2.23606797749979},"39":{"tf":2.8284271247461903},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":2.23606797749979},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":2.23606797749979},"47":{"tf":4.0},"48":{"tf":2.0},"49":{"tf":2.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"62":{"tf":1.0},"69":{"tf":2.23606797749979},"7":{"tf":1.0},"70":{"tf":1.7320508075688772},"71":{"tf":2.0},"72":{"tf":3.4641016151377544},"73":{"tf":2.23606797749979},"74":{"tf":1.0},"75":{"tf":2.0},"76":{"tf":1.7320508075688772}},"’":{"df":2,"docs":{"16":{"tf":1.0},"42":{"tf":1.0}}}}},"i":{"c":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":13,"docs":{"10":{"tf":1.0},"16":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":2.0},"46":{"tf":1.4142135623730951},"5":{"tf":1.0},"53":{"tf":1.7320508075688772},"56":{"tf":1.0},"73":{"tf":1.4142135623730951}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"74":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"64":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":2,"docs":{"5":{"tf":1.0},"6":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"df":0,"docs":{}}},"w":{"df":1,"docs":{"30":{"tf":1.4142135623730951}},"n":{"df":2,"docs":{"53":{"tf":1.0},"62":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"55":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"38":{"tf":1.0},"53":{"tf":1.0}},"i":{"df":2,"docs":{"38":{"tf":1.0},"48":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"46":{"tf":1.0},"76":{"tf":1.0}},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"3":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}},"k":{"df":1,"docs":{"56":{"tf":1.0}}}},"x":{"df":1,"docs":{"8":{"tf":1.0}}},"z":{"df":0,"docs":{},"e":{"df":2,"docs":{"53":{"tf":1.0},"55":{"tf":1.4142135623730951}}}}},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"19":{"tf":1.0},"69":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"16":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"64":{"tf":1.0}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"25":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"r":{"c":{"df":3,"docs":{"2":{"tf":1.0},"56":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":20,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"4":{"tf":1.7320508075688772},"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"72":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"48":{"tf":1.0}}}}},":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"66":{"tf":1.4142135623730951}}}}}}}},"df":7,"docs":{"36":{"tf":1.0},"54":{"tf":1.0},"60":{"tf":1.7320508075688772},"62":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":3,"docs":{"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"55":{"tf":2.23606797749979},"70":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":4,"docs":{"17":{"tf":1.0},"21":{"tf":1.0},"58":{"tf":1.0},"69":{"tf":1.0}},"i":{"df":5,"docs":{"36":{"tf":1.0},"53":{"tf":1.7320508075688772},"56":{"tf":1.0},"61":{"tf":1.0},"72":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":2.23606797749979}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"d":{"df":3,"docs":{"21":{"tf":1.7320508075688772},"57":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"r":{"c":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.0}}}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}},"r":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":12,"docs":{"19":{"tf":1.0},"27":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"52":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":2.0},"65":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"25":{"tf":1.0}}},"u":{"df":3,"docs":{"11":{"tf":1.0},"42":{"tf":1.0},"73":{"tf":1.0}}}},"y":{"df":1,"docs":{"62":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":3,"docs":{"38":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":1.7320508075688772}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"55":{"tf":1.0},"73":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"53":{"tf":1.0}}},"i":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"76":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"18":{"tf":1.0},"25":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":5,"docs":{"2":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"42":{"tf":1.0},"51":{"tf":1.0},"69":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"40":{"tf":1.0},"56":{"tf":1.0},"76":{"tf":1.0}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"38":{"tf":1.0},"62":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":5,"docs":{"11":{"tf":1.0},"36":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"65":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"72":{"tf":1.4142135623730951},"73":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"52":{"tf":1.0},"72":{"tf":1.0}}}},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}}}},"df":2,"docs":{"19":{"tf":1.0},"30":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"(":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":8,"docs":{"17":{"tf":3.3166247903554},"19":{"tf":2.23606797749979},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.7320508075688772},"62":{"tf":2.6457513110645907},"66":{"tf":3.872983346207417}},"’":{"df":3,"docs":{"62":{"tf":1.4142135623730951},"66":{"tf":2.0},"67":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"56":{"tf":1.7320508075688772},"62":{"tf":1.0},"8":{"tf":2.0}}}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"51":{"tf":1.0},"61":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":4,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"34":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"’":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"52":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":4,"docs":{"27":{"tf":1.0},"43":{"tf":1.0},"55":{"tf":1.0},"66":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"42":{"tf":1.0},"55":{"tf":1.0},"62":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":3,"docs":{"22":{"tf":1.0},"30":{"tf":1.0},"53":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"69":{"tf":1.0},"76":{"tf":1.0}}}}}}}},"i":{"df":1,"docs":{"62":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":7,"docs":{"18":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}},"r":{"(":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":2.6457513110645907}}}}},"p":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}},"t":{"df":0,"docs":{},"l":{"df":6,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"28":{"tf":1.0},"37":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0}}}}},"l":{"df":3,"docs":{"23":{"tf":1.0},"42":{"tf":1.4142135623730951},"47":{"tf":1.0}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"38":{"tf":1.0},"42":{"tf":1.0}}}},"p":{"df":2,"docs":{"18":{"tf":1.0},"62":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.0},"62":{"tf":1.0}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"o":{"df":8,"docs":{"19":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.4142135623730951}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":5,"docs":{"19":{"tf":2.0},"20":{"tf":1.4142135623730951},"38":{"tf":1.0},"62":{"tf":1.0},"69":{"tf":1.0}}}}}},"u":{"d":{"df":0,"docs":{},"p":{"df":3,"docs":{"22":{"tf":1.0},"40":{"tf":1.0},"72":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":2,"docs":{"30":{"tf":1.0},"34":{"tf":1.0}}},"n":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":1.0},"37":{"tf":1.0},"49":{"tf":1.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"21":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":2,"docs":{"39":{"tf":1.0},"62":{"tf":1.0}}}},"t":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"7":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":4,"docs":{"23":{"tf":1.0},"25":{"tf":1.0},"62":{"tf":1.0},"8":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"51":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}},"df":9,"docs":{"16":{"tf":1.0},"21":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"72":{"tf":1.0}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":21,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"38":{"tf":1.0},"40":{"tf":1.7320508075688772},"41":{"tf":2.23606797749979},"42":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"5":{"tf":1.0},"52":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.7320508075688772},"67":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"25":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"49":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"21":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"1":{".":{"5":{".":{"0":{"df":2,"docs":{"0":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":3,"docs":{"16":{"tf":1.0},"21":{"tf":1.4142135623730951},"64":{"tf":1.0}}}},"r":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"/":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"56":{"tf":1.0},"69":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"23":{"tf":1.0},"3":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"68":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"16":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"p":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":16,"docs":{"12":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"27":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951}}}},"s":{"d":{"df":2,"docs":{"27":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":8,"docs":{"18":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"48":{"tf":1.0},"56":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"51":{"tf":1.0},"69":{"tf":1.0}}}}}},"b":{"df":1,"docs":{"23":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"39":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"16":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"61":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"14":{"tf":1.0},"67":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"22":{"tf":1.4142135623730951},"39":{"tf":1.0},"45":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"75":{"tf":1.0}},"e":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"i":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"53":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"20":{"tf":1.0},"22":{"tf":1.0},"30":{"tf":1.0},"48":{"tf":1.0}}}}},"df":6,"docs":{"18":{"tf":1.4142135623730951},"36":{"tf":1.0},"61":{"tf":2.0},"62":{"tf":2.8284271247461903},"63":{"tf":1.7320508075688772},"65":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"38":{"tf":1.0},"62":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"42":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}},"’":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"40":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"k":{"df":4,"docs":{"16":{"tf":1.4142135623730951},"37":{"tf":1.0},"39":{"tf":1.0},"73":{"tf":1.0}}},"l":{"d":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":7,"docs":{"27":{"tf":1.0},"53":{"tf":2.23606797749979},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":3,"docs":{"38":{"tf":1.0},"42":{"tf":1.0},"71":{"tf":1.0}}}}}}},"x":{"d":{"df":0,"docs":{},"g":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"60":{"tf":1.0}}},"y":{"df":1,"docs":{"60":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"’":{"df":0,"docs":{},"r":{"df":10,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772},"42":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"v":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"65":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"55":{"tf":1.0},"57":{"tf":1.7320508075688772},"69":{"tf":1.0}}}},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}}}}},"breadcrumbs":{"root":{"0":{".":{"2":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"56":{"tf":1.0}}},"7":{"5":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"21":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":2.23606797749979},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":2.6457513110645907}}},"1":{".":{"5":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"0":{"df":1,"docs":{"62":{"tf":2.8284271247461903}}},"2":{".":{"5":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"7":{"df":1,"docs":{"55":{"tf":1.0}}},"df":1,"docs":{"66":{"tf":2.0}}},"4":{".":{"5":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":2,"docs":{"55":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951}}},"9":{"df":2,"docs":{"57":{"tf":1.4142135623730951},"63":{"tf":1.0}}},"df":8,"docs":{"37":{"tf":1.0},"38":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":2.449489742783178},"64":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.0}}},"2":{"0":{"df":2,"docs":{"53":{"tf":1.0},"63":{"tf":1.4142135623730951}}},"1":{"df":1,"docs":{"63":{"tf":1.0}}},"2":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"56":{"tf":1.0}}},"4":{"df":1,"docs":{"56":{"tf":1.0}}},"5":{".":{"5":{"df":2,"docs":{"62":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"5":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"7":{".":{"5":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":1,"docs":{"66":{"tf":2.449489742783178}}},"df":4,"docs":{"38":{"tf":1.0},"40":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0}}},"3":{".":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"0":{"0":{"df":1,"docs":{"62":{"tf":1.0}}},"df":3,"docs":{"62":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"df":0,"docs":{}},"4":{".":{"5":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"0":{"8":{"0":{"df":2,"docs":{"40":{"tf":1.7320508075688772},"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"55":{"tf":1.4142135623730951},"57":{"tf":1.0}}},"5":{"df":2,"docs":{"57":{"tf":1.0},"62":{"tf":1.0}}},"6":{"0":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"55":{"tf":1.0}}},"4":{"df":1,"docs":{"72":{"tf":1.0}}},"df":1,"docs":{"66":{"tf":2.0}}},"7":{"5":{"df":1,"docs":{"21":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"9":{".":{"5":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":5,"docs":{"16":{"tf":1.0},"34":{"tf":1.0},"45":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"39":{"tf":1.0},"48":{"tf":1.4142135623730951},"61":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":8,"docs":{"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"76":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"30":{"tf":2.23606797749979},"55":{"tf":1.0}}}},"v":{"df":1,"docs":{"27":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"18":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":1.0},"53":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":12,"docs":{"30":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"55":{"tf":1.0},"58":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":7,"docs":{"16":{"tf":1.7320508075688772},"37":{"tf":1.0},"40":{"tf":2.23606797749979},"41":{"tf":2.6457513110645907},"47":{"tf":1.7320508075688772},"49":{"tf":1.0},"72":{"tf":1.0}}}}}}},"df":5,"docs":{"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"35":{"tf":1.0},"38":{"tf":1.0},"69":{"tf":1.7320508075688772}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"3":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"i":{"a":{"df":2,"docs":{"21":{"tf":1.0},"64":{"tf":1.0}},"s":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"v":{"df":2,"docs":{"38":{"tf":1.0},"62":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":10,"docs":{"11":{"tf":1.0},"19":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":2.449489742783178},"56":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"22":{"tf":1.0},"26":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":4,"docs":{"36":{"tf":1.0},"54":{"tf":1.4142135623730951},"69":{"tf":2.0},"7":{"tf":1.7320508075688772}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"18":{"tf":1.0},"57":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":9,"docs":{"21":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"47":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}},"p":{"df":0,"docs":{},"p":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"37":{"tf":1.0},"38":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"r":{"a":{"b":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"55":{"tf":1.4142135623730951},"57":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"55":{"tf":2.6457513110645907}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"39":{"tf":1.0},"47":{"tf":1.7320508075688772},"48":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"27":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"27":{"tf":1.0},"5":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"0":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"40":{"tf":1.0},"42":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"52":{"tf":1.0}}},"k":{"df":4,"docs":{"24":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":2.0},"38":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"42":{"tf":1.4142135623730951},"45":{"tf":1.0},"47":{"tf":1.0},"72":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":11,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"63":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"62":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"r":{"df":2,"docs":{"6":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"62":{"tf":2.0},"66":{"tf":2.449489742783178},"67":{"tf":1.0}},"’":{"df":1,"docs":{"66":{"tf":1.0}}}},"i":{"c":{"df":3,"docs":{"35":{"tf":1.0},"36":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}}},"df":2,"docs":{"59":{"tf":1.0},"66":{"tf":1.0}},"e":{"df":9,"docs":{"23":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":1.0},"46":{"tf":1.0},"56":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"27":{"tf":1.4142135623730951},"42":{"tf":1.0},"64":{"tf":1.4142135623730951}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"11":{"tf":1.0},"20":{"tf":1.0},"74":{"tf":1.4142135623730951}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"25":{"tf":1.0},"26":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"22":{"tf":1.0},"27":{"tf":1.0},"56":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0}}}}}}}},"i":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"19":{"tf":1.0},"30":{"tf":2.23606797749979},"70":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":4,"docs":{"36":{"tf":1.0},"44":{"tf":1.0},"53":{"tf":3.0},"56":{"tf":1.4142135623730951}},"s":{".":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"s":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"_":{"df":0,"docs":{},"s":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"2":{"tf":1.0}}}},"u":{"df":0,"docs":{},"e":{"df":5,"docs":{"24":{"tf":1.0},"59":{"tf":2.0},"62":{"tf":1.0},"66":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"13":{"tf":1.0}},"h":{"df":7,"docs":{"3":{"tf":1.0},"37":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"22":{"tf":1.0},"6":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"66":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":2,"docs":{"33":{"tf":1.0},"46":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":9,"docs":{"17":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.7320508075688772},"56":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"12":{"tf":1.7320508075688772},"16":{"tf":1.0},"30":{"tf":2.6457513110645907},"37":{"tf":1.7320508075688772},"41":{"tf":1.0},"5":{"tf":2.0},"50":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"21":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"5":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"62":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"5":{"tf":1.0},"66":{"tf":2.0}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"e":{"df":4,"docs":{"16":{"tf":1.0},"40":{"tf":1.0},"63":{"tf":1.0},"73":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}}}}},"v":{"df":0,"docs":{},"e":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"/":{"c":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"18":{"tf":1.4142135623730951},"30":{"tf":1.0},"38":{"tf":1.0},"55":{"tf":1.0}}}}},"df":1,"docs":{"42":{"tf":2.0}},"i":{"df":0,"docs":{},"f":{"df":3,"docs":{"23":{"tf":1.0},"42":{"tf":2.8284271247461903},"47":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":18,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.4142135623730951},"56":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0}}}},"t":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":6,"docs":{"19":{"tf":2.8284271247461903},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":2.0},"25":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":2,"docs":{"12":{"tf":1.0},"27":{"tf":1.0}}}}},"df":1,"docs":{"72":{"tf":1.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":2.0}}}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"a":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":3,"docs":{"21":{"tf":1.0},"34":{"tf":1.0},"70":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":9,"docs":{"12":{"tf":1.7320508075688772},"16":{"tf":2.8284271247461903},"27":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":2.23606797749979},"37":{"tf":2.449489742783178},"41":{"tf":1.4142135623730951},"50":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"22":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":2.23606797749979},"46":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"69":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":3,"docs":{"2":{"tf":1.0},"52":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"d":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.0}}},"u":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":5,"docs":{"10":{"tf":1.0},"29":{"tf":1.0},"55":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"22":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":21,"docs":{"11":{"tf":1.0},"17":{"tf":1.4142135623730951},"20":{"tf":2.8284271247461903},"21":{"tf":1.0},"27":{"tf":1.0},"35":{"tf":1.4142135623730951},"38":{"tf":2.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":2.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":2.0},"48":{"tf":1.4142135623730951},"64":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":5,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"21":{"tf":1.0},"38":{"tf":1.0},"52":{"tf":1.0},"71":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"18":{"tf":1.0},"61":{"tf":1.7320508075688772},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":15,"docs":{"36":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772},"46":{"tf":2.0},"52":{"tf":2.0},"56":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":2.449489742783178},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}},"s":{"/":{"c":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"53":{"tf":1.0},"75":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"60":{"tf":1.0},"62":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"38":{"tf":1.4142135623730951},"62":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":28,"docs":{"36":{"tf":2.23606797749979},"37":{"tf":1.0},"38":{"tf":1.7320508075688772},"39":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.0},"51":{"tf":2.23606797749979},"52":{"tf":1.4142135623730951},"53":{"tf":2.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":2.6457513110645907},"7":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":11,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":2.0},"25":{"tf":2.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"53":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":9,"docs":{"42":{"tf":1.0},"47":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":2.449489742783178},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"0":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"11":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"53":{"tf":1.0},"69":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":7,"docs":{"25":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"18":{"tf":1.0},"22":{"tf":1.0},"62":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"61":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"36":{"tf":1.0},"54":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"35":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772},"38":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"51":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"’":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":4,"docs":{"11":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.4142135623730951},"69":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":3,"docs":{"10":{"tf":1.4142135623730951},"18":{"tf":1.0},"70":{"tf":1.0}}}}}}}}}},"d":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"1":{"8":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"7":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"0":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"21":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"62":{"tf":1.0},"63":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"31":{"tf":1.0},"55":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":4,"docs":{"18":{"tf":1.0},"21":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"66":{"tf":2.6457513110645907}}}}},"df":22,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":2.0},"73":{"tf":1.0},"75":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"16":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"c":{"df":1,"docs":{"53":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}},"r":{"df":2,"docs":{"37":{"tf":1.0},"56":{"tf":1.0}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"i":{"c":{"df":3,"docs":{"11":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"19":{"tf":1.0},"36":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"72":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"5":{"tf":1.0},"56":{"tf":1.0},"69":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"38":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"52":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"12":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"46":{"tf":1.0},"58":{"tf":1.0},"64":{"tf":1.0}}}},"d":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"25":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"44":{"tf":1.0},"46":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"44":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"73":{"tf":1.0}},"i":{"df":3,"docs":{"47":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"72":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":4,"docs":{"22":{"tf":1.0},"6":{"tf":1.7320508075688772},"62":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":1.0},"52":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"n":{"df":1,"docs":{"41":{"tf":1.0}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.4142135623730951},"2":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}}}}},"df":1,"docs":{"38":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":8,"docs":{"14":{"tf":1.0},"22":{"tf":1.0},"37":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"16":{"tf":1.0},"42":{"tf":1.4142135623730951},"49":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":6,"docs":{"19":{"tf":1.0},"21":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"64":{"tf":1.0}}},"’":{"df":0,"docs":{},"t":{"df":6,"docs":{"16":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"41":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"37":{"tf":1.0},"5":{"tf":1.0},"62":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"37":{"tf":1.0},"5":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}}},"y":{"df":1,"docs":{"61":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":10,"docs":{"11":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"53":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":5,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":2.0}}}}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"df":8,"docs":{"21":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":2.8284271247461903},"69":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"18":{"tf":1.0},"27":{"tf":1.0},"61":{"tf":1.7320508075688772},"62":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772},"65":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"26":{"tf":1.0},"31":{"tf":1.0},"58":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951}}}}}}},"d":{"df":4,"docs":{"27":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"40":{"tf":1.0},"52":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"56":{"tf":1.0},"73":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"16":{"tf":1.7320508075688772},"19":{"tf":1.0},"20":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.23606797749979},"42":{"tf":1.0},"56":{"tf":1.7320508075688772},"72":{"tf":1.7320508075688772},"73":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}},"t":{"df":6,"docs":{"18":{"tf":1.0},"54":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.0}},"u":{"df":1,"docs":{"4":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"16":{"tf":1.0},"37":{"tf":1.0},"51":{"tf":1.0},"69":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"20":{"tf":1.0},"49":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0},"72":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":17,"docs":{"18":{"tf":1.0},"21":{"tf":1.4142135623730951},"30":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":2.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.7320508075688772},"60":{"tf":1.0},"62":{"tf":1.7320508075688772},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"53":{"tf":1.0}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"20":{"tf":1.0},"21":{"tf":1.0},"27":{"tf":1.0},"42":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"14":{"tf":1.4142135623730951},"3":{"tf":1.0},"76":{"tf":1.0}}}},"t":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}},"n":{"df":2,"docs":{"45":{"tf":1.0},"53":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"38":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}}},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"62":{"tf":1.0},"63":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"27":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"36":{"tf":1.0},"56":{"tf":1.0}}}}}},"df":0,"docs":{},"w":{"df":4,"docs":{"18":{"tf":1.0},"39":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"53":{"tf":1.4142135623730951},"54":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":4,"docs":{"38":{"tf":1.4142135623730951},"52":{"tf":2.0},"53":{"tf":1.0},"76":{"tf":1.0}}},"l":{"df":2,"docs":{"38":{"tf":1.0},"40":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"53":{"tf":1.0}}}},"d":{"df":2,"docs":{"51":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"61":{"tf":1.0}}}},"t":{"df":2,"docs":{"13":{"tf":1.0},"7":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":6,"docs":{"17":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.4142135623730951},"63":{"tf":1.0},"69":{"tf":1.4142135623730951},"8":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"16":{"tf":1.0},"40":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":13,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"30":{"tf":1.4142135623730951},"36":{"tf":1.0},"39":{"tf":1.0},"52":{"tf":1.0},"62":{"tf":1.7320508075688772},"63":{"tf":1.0}},"t":{"df":0,"docs":{},"o":{"(":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"v":{"df":0,"docs":{},"e":{"df":4,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"38":{"tf":1.0},"62":{"tf":1.7320508075688772}}}},"x":{"df":2,"docs":{"60":{"tf":1.0},"62":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"5":{"tf":1.0},"66":{"tf":3.0},"67":{"tf":2.0}},"’":{"df":1,"docs":{"66":{"tf":1.0}}}},"t":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"37":{"tf":1.0},"38":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"27":{"tf":1.0},"62":{"tf":1.0},"8":{"tf":1.0}}}}}},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"65":{"tf":1.0}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}},"k":{"df":2,"docs":{"49":{"tf":1.0},"69":{"tf":1.4142135623730951}}},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"42":{"tf":1.0},"52":{"tf":1.0},"65":{"tf":1.0}}}},"df":2,"docs":{"11":{"tf":1.0},"46":{"tf":1.0}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"45":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"21":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"54":{"tf":1.0},"62":{"tf":1.4142135623730951},"66":{"tf":1.0}},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"3":{"tf":1.0},"35":{"tf":1.4142135623730951},"69":{"tf":1.0}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"51":{"tf":1.0},"55":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"df":2,"docs":{"33":{"tf":1.0},"47":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":41,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":2.6457513110645907},"17":{"tf":1.0},"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"27":{"tf":2.23606797749979},"35":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"41":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":2.0},"49":{"tf":1.7320508075688772},"5":{"tf":1.0},"51":{"tf":1.7320508075688772},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":1.0},"61":{"tf":2.23606797749979},"62":{"tf":2.0},"63":{"tf":1.7320508075688772},"64":{"tf":2.23606797749979},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":4.123105625617661},"73":{"tf":2.449489742783178},"75":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}}},"’":{"df":4,"docs":{"3":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.0},"69":{"tf":1.0}}}}}},"df":1,"docs":{"19":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}},"t":{"df":4,"docs":{"18":{"tf":1.0},"47":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":4,"docs":{"57":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0},"8":{"tf":1.0}},"n":{"df":2,"docs":{"46":{"tf":1.0},"47":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"19":{"tf":1.4142135623730951},"39":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"73":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"49":{"tf":1.0}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"51":{"tf":1.0},"63":{"tf":1.4142135623730951}}}},"df":3,"docs":{"10":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0}},"e":{"df":1,"docs":{"37":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"56":{"tf":1.0}},"i":{"c":{"df":2,"docs":{"28":{"tf":1.0},"31":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"23":{"tf":1.0},"8":{"tf":1.0}}}},"y":{"df":1,"docs":{"12":{"tf":1.0}}}},"i":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":1,"docs":{"53":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}},"i":{"d":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":2,"docs":{"35":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772}}}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"18":{"tf":1.0},"48":{"tf":1.0},"8":{"tf":1.0}}}}}},"r":{"d":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":4,"docs":{"35":{"tf":1.0},"47":{"tf":1.0},"63":{"tf":1.4142135623730951},"72":{"tf":1.0}},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"4":{"tf":1.0},"6":{"tf":2.449489742783178},"8":{"tf":2.449489742783178}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.7320508075688772}}}}}},"l":{"df":0,"docs":{},"p":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":5,"docs":{"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"34":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":24,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"18":{"tf":1.0},"22":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"46":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0}},"’":{"df":6,"docs":{"0":{"tf":1.0},"45":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":1.0},"62":{"tf":1.0},"69":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"18":{"tf":1.0},"47":{"tf":1.0}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}}},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":19,"docs":{"16":{"tf":2.23606797749979},"23":{"tf":1.0},"35":{"tf":2.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":2.0},"49":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"41":{"tf":1.0},"47":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":1,"docs":{"23":{"tf":1.0}},"s":{":":{"/":{"/":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}},"e":{"/":{"c":{"/":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}},"e":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"d":{"df":7,"docs":{"16":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":3.3166247903554},"73":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}},"e":{"a":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"3":{"tf":1.0},"55":{"tf":1.0},"69":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":7,"docs":{"36":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"52":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":6,"docs":{"11":{"tf":1.0},"18":{"tf":1.0},"34":{"tf":1.0},"62":{"tf":1.4142135623730951},"67":{"tf":2.23606797749979},"8":{"tf":2.449489742783178}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":3,"docs":{"56":{"tf":1.7320508075688772},"66":{"tf":1.0},"67":{"tf":1.0}}}},"i":{"c":{"df":4,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"74":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":2,"docs":{"53":{"tf":1.7320508075688772},"65":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"53":{"tf":1.0},"7":{"tf":1.0}}}}}},"o":{"df":2,"docs":{"49":{"tf":2.0},"50":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"m":{"df":10,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"22":{"tf":1.0},"38":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.7320508075688772},"52":{"tf":1.0},"54":{"tf":1.0},"65":{"tf":1.0},"73":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"28":{"tf":1.0},"30":{"tf":2.23606797749979},"42":{"tf":1.0},"61":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"22":{"tf":1.0},"25":{"tf":2.23606797749979}}}}},"df":0,"docs":{}},"i":{"d":{"df":3,"docs":{"38":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":8,"docs":{"20":{"tf":1.0},"21":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"62":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"16":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"53":{"tf":1.0}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":9,"docs":{"16":{"tf":1.0},"25":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.7320508075688772},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"73":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":3,"docs":{"4":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0}}}}}}},"p":{"df":4,"docs":{"16":{"tf":1.0},"40":{"tf":2.0},"41":{"tf":2.449489742783178},"49":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":9,"docs":{"24":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0},"71":{"tf":1.0}}}}},"p":{"df":1,"docs":{"25":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"51":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"36":{"tf":1.0}}}},"’":{"df":4,"docs":{"25":{"tf":1.0},"49":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.0}}}},"’":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}},"j":{"df":1,"docs":{"5":{"tf":1.0}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"44":{"tf":1.4142135623730951},"46":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}},"df":13,"docs":{"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"27":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772},"64":{"tf":1.0},"72":{"tf":1.7320508075688772},"73":{"tf":1.0}}}}}},"k":{"df":1,"docs":{"5":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":3,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"41":{"tf":1.0}}}},"y":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":5,"docs":{"11":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"5":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":9,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"18":{"tf":2.0},"4":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":2.0},"63":{"tf":1.7320508075688772},"64":{"tf":1.0},"69":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"36":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"49":{"tf":1.0}}}}}},"l":{"0":{"df":0,"docs":{},"v":{"3":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"4":{"c":{"3":{"5":{"df":0,"docs":{},"h":{"1":{"df":0,"docs":{},"p":{"5":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"53":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"18":{"tf":1.0},"38":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"v":{"df":3,"docs":{"38":{"tf":1.0},"56":{"tf":1.7320508075688772},"57":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":3,"docs":{"18":{"tf":1.0},"22":{"tf":1.0},"5":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.7320508075688772},"2":{"tf":1.0}}},"y":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"47":{"tf":1.0}}}},"t":{"df":1,"docs":{"19":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":9,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":3.1622776601683795},"13":{"tf":2.23606797749979},"14":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951}}}}}},"i":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"36":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"72":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":13,"docs":{"35":{"tf":1.4142135623730951},"38":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":2.0},"48":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951}}},"k":{"df":2,"docs":{"2":{"tf":1.4142135623730951},"52":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":12,"docs":{"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"20":{"tf":1.0},"30":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"53":{"tf":1.0},"55":{"tf":1.0},"69":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"62":{"tf":1.7320508075688772},"67":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":5,"docs":{"13":{"tf":1.4142135623730951},"18":{"tf":1.0},"25":{"tf":1.0},"38":{"tf":1.0},"62":{"tf":1.4142135623730951}}}}},"o":{"b":{"b":{"df":0,"docs":{},"i":{"df":2,"docs":{"60":{"tf":1.0},"64":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":12,"docs":{"16":{"tf":2.0},"22":{"tf":1.0},"24":{"tf":2.449489742783178},"35":{"tf":1.0},"37":{"tf":1.7320508075688772},"39":{"tf":1.0},"44":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"53":{"tf":1.0},"72":{"tf":1.0}}},"t":{"df":5,"docs":{"14":{"tf":1.0},"38":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":3,"docs":{"22":{"tf":1.0},"38":{"tf":2.0},"71":{"tf":1.0}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"51":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"5":{"tf":1.0},"52":{"tf":1.4142135623730951}}},"p":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"44":{"tf":1.0},"45":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"13":{"tf":1.7320508075688772},"18":{"tf":1.0},"62":{"tf":1.0}}},"t":{"df":2,"docs":{"47":{"tf":1.0},"63":{"tf":1.0}}}},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"39":{"tf":1.0},"51":{"tf":1.0}}}}}},"df":0,"docs":{}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.7320508075688772}}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"e":{"df":10,"docs":{"21":{"tf":1.4142135623730951},"34":{"tf":1.0},"40":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"26":{"tf":1.0}},"i":{"df":3,"docs":{"18":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.4142135623730951}}},"u":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"16":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"p":{"df":7,"docs":{"13":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"53":{"tf":1.7320508075688772},"72":{"tf":1.0},"75":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"0":{"tf":1.7320508075688772},"2":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"y":{"b":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"e":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":4,"docs":{"22":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"47":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"19":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"16":{"tf":1.0},"26":{"tf":1.0}}}}}},"u":{"df":1,"docs":{"37":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":6,"docs":{"11":{"tf":1.0},"19":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":2,"docs":{"26":{"tf":1.0},"5":{"tf":1.0}}}},"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":4,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"27":{"tf":2.23606797749979},"62":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"26":{"tf":1.0},"69":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":12,"docs":{"0":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"27":{"tf":1.0},"30":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772}}}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"27":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"53":{"tf":1.0},"8":{"tf":1.0}}}}}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":15,"docs":{"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.7320508075688772}}}},"df":6,"docs":{"46":{"tf":1.0},"5":{"tf":1.0},"62":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.7320508075688772}}}}}}}},"y":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":10,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"29":{"tf":1.0},"42":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"49":{"tf":1.0},"53":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"48":{"tf":1.0}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":1,"docs":{"18":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":14,"docs":{"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.7320508075688772},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":11,"docs":{"16":{"tf":2.0},"24":{"tf":1.7320508075688772},"35":{"tf":1.0},"37":{"tf":1.4142135623730951},"39":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0}}}}}}},"w":{"df":3,"docs":{"21":{"tf":1.0},"3":{"tf":1.0},"69":{"tf":1.0}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"25":{"tf":1.0},"56":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"df":2,"docs":{"73":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}},"df":2,"docs":{"44":{"tf":1.0},"45":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":8,"docs":{"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.7320508075688772}}},"h":{"df":1,"docs":{"26":{"tf":1.0}}}},"w":{"df":10,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.4142135623730951},"51":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"13":{"tf":1.0},"21":{"tf":1.0},"53":{"tf":1.0},"6":{"tf":1.0},"68":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"51":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"47":{"tf":1.0},"50":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"61":{"tf":1.0},"62":{"tf":1.7320508075688772}},"i":{"df":2,"docs":{"61":{"tf":1.0},"62":{"tf":1.4142135623730951}}}},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"c":{"df":1,"docs":{"43":{"tf":1.0}}},"df":11,"docs":{"12":{"tf":1.0},"22":{"tf":1.0},"30":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.4142135623730951},"63":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":11,"docs":{"16":{"tf":2.0},"22":{"tf":1.0},"33":{"tf":1.7320508075688772},"39":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"53":{"tf":1.0},"72":{"tf":1.0}}}}}},"p":{"df":1,"docs":{"53":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"22":{"tf":1.0},"30":{"tf":1.4142135623730951}}},"r":{"df":3,"docs":{"11":{"tf":1.7320508075688772},"53":{"tf":1.0},"63":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"44":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":5,"docs":{"12":{"tf":1.0},"27":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.4142135623730951},"73":{"tf":1.0}},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"62":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"37":{"tf":1.0},"44":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"22":{"tf":1.0},"30":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"49":{"tf":1.0},"73":{"tf":1.0}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}}}}}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"22":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951}}}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"3":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"31":{"tf":1.0},"61":{"tf":1.7320508075688772}},"i":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"16":{"tf":1.4142135623730951},"36":{"tf":1.0},"38":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"26":{"tf":1.0}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"43":{"tf":1.0},"73":{"tf":1.4142135623730951},"76":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":5,"docs":{"22":{"tf":1.0},"25":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":2.449489742783178},"76":{"tf":1.0}}}}},"df":4,"docs":{"39":{"tf":1.0},"46":{"tf":1.7320508075688772},"73":{"tf":1.4142135623730951},"76":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}}},"m":{"df":1,"docs":{"42":{"tf":1.0}}},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":5,"docs":{"26":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"o":{"d":{"df":5,"docs":{"41":{"tf":1.0},"47":{"tf":1.0},"62":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}},"h":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"51":{"tf":1.0},"53":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"70":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"y":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":32,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":2.8284271247461903},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":2.449489742783178},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.7320508075688772},"3":{"tf":2.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772},"41":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"(":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":30,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":1.0},"18":{"tf":1.7320508075688772},"19":{"tf":2.0},"21":{"tf":1.0},"27":{"tf":2.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.7320508075688772},"4":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"53":{"tf":1.4142135623730951},"56":{"tf":2.23606797749979},"57":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":2.23606797749979},"62":{"tf":2.8284271247461903},"63":{"tf":2.8284271247461903},"64":{"tf":2.449489742783178},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":3.1622776601683795},"7":{"tf":1.0},"72":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951}},"’":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":1,"docs":{"55":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.4142135623730951},"70":{"tf":1.0}}}}},"p":{"df":3,"docs":{"16":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.0}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"55":{"tf":1.0},"56":{"tf":3.7416573867739413},"62":{"tf":1.0}},"’":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":5,"docs":{"16":{"tf":1.0},"40":{"tf":2.6457513110645907},"41":{"tf":1.7320508075688772},"47":{"tf":1.7320508075688772},"72":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"55":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":9,"docs":{"18":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"40":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.4142135623730951},"60":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":5,"docs":{"34":{"tf":1.0},"36":{"tf":1.0},"54":{"tf":1.4142135623730951},"57":{"tf":1.0},"8":{"tf":3.3166247903554}}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"41":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"54":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"76":{"tf":1.0}}}}},"s":{"df":6,"docs":{"19":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"27":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":2.23606797749979},"9":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"0":{"tf":1.0},"51":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"26":{"tf":1.0},"46":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"73":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"73":{"tf":1.0}}}},"v":{"a":{"c":{"df":0,"docs":{},"i":{"df":5,"docs":{"39":{"tf":1.0},"44":{"tf":2.23606797749979},"45":{"tf":1.7320508075688772},"46":{"tf":2.0},"73":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"df":6,"docs":{"11":{"tf":1.0},"40":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"63":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"71":{"tf":1.4142135623730951},"75":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":8,"docs":{"30":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":5,"docs":{"16":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":2.0},"47":{"tf":2.8284271247461903},"48":{"tf":2.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"16":{"tf":1.0},"38":{"tf":1.0},"73":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"47":{"tf":3.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}},"t":{"df":2,"docs":{"27":{"tf":1.0},"64":{"tf":1.0}}}}},"q":{"df":1,"docs":{"5":{"tf":1.0}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"i":{"c":{"df":1,"docs":{"22":{"tf":1.0}},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"56":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.0}}}},"w":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":3,"docs":{"59":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"14":{"tf":1.0},"23":{"tf":1.0},"39":{"tf":1.0}}}},"d":{"df":3,"docs":{"17":{"tf":1.0},"22":{"tf":1.0},"41":{"tf":1.0}},"i":{"df":1,"docs":{"64":{"tf":1.7320508075688772}}},"y":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"42":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"16":{"tf":1.0},"37":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"30":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"38":{"tf":1.0},"40":{"tf":1.0},"47":{"tf":1.0},"52":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":1,"docs":{"11":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":4,"docs":{"56":{"tf":1.7320508075688772},"57":{"tf":1.0},"62":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}},"d":{"df":5,"docs":{"25":{"tf":1.0},"59":{"tf":2.0},"62":{"tf":1.0},"66":{"tf":1.7320508075688772},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"21":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"25":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"55":{"tf":1.0},"57":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"o":{"a":{"d":{"df":4,"docs":{"21":{"tf":1.0},"37":{"tf":1.0},"70":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"76":{"tf":1.0}}},"df":2,"docs":{"18":{"tf":1.0},"62":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"47":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"75":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":2,"docs":{"42":{"tf":1.0},"47":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"38":{"tf":1.0}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"33":{"tf":1.0},"49":{"tf":1.7320508075688772},"50":{"tf":1.0},"72":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":4,"docs":{"41":{"tf":1.0},"49":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"61":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.0},"42":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"44":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"73":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"41":{"tf":1.0},"53":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"17":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":8,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"51":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.0},"62":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"72":{"tf":1.4142135623730951},"73":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"72":{"tf":1.0}}}},"n":{"df":15,"docs":{"17":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"38":{"tf":1.0},"42":{"tf":1.7320508075688772},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.7320508075688772},"75":{"tf":1.0},"76":{"tf":1.0}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"25":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":10,"docs":{"23":{"tf":1.4142135623730951},"30":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"57":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.0}}}}},"n":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":2,"docs":{"37":{"tf":1.0},"38":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}},"y":{"df":3,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":4,"docs":{"52":{"tf":1.0},"54":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":9,"docs":{"18":{"tf":1.4142135623730951},"36":{"tf":1.0},"61":{"tf":2.6457513110645907},"62":{"tf":3.3166247903554},"63":{"tf":1.7320508075688772},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":2.8284271247461903}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":12,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"6":{"tf":1.0},"62":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}}}}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":1,"docs":{"65":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"16":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"53":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"19":{"tf":1.0},"30":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"22":{"tf":2.6457513110645907},"23":{"tf":2.449489742783178},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"47":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":8,"docs":{"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.0}},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.0},"37":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"df":5,"docs":{"19":{"tf":1.0},"20":{"tf":2.0},"22":{"tf":1.0},"25":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":53,"docs":{"14":{"tf":1.0},"16":{"tf":2.8284271247461903},"17":{"tf":1.7320508075688772},"18":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"33":{"tf":2.23606797749979},"35":{"tf":2.6457513110645907},"36":{"tf":1.7320508075688772},"37":{"tf":2.6457513110645907},"38":{"tf":2.449489742783178},"39":{"tf":3.1622776601683795},"40":{"tf":1.7320508075688772},"41":{"tf":2.0},"42":{"tf":2.449489742783178},"43":{"tf":2.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":2.449489742783178},"47":{"tf":4.242640687119285},"48":{"tf":2.449489742783178},"49":{"tf":2.449489742783178},"50":{"tf":1.0},"51":{"tf":2.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":2.449489742783178},"7":{"tf":1.0},"70":{"tf":2.0},"71":{"tf":2.449489742783178},"72":{"tf":3.605551275463989},"73":{"tf":2.6457513110645907},"74":{"tf":1.4142135623730951},"75":{"tf":2.449489742783178},"76":{"tf":2.23606797749979}},"’":{"df":2,"docs":{"16":{"tf":1.0},"42":{"tf":1.0}}}}},"i":{"c":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":17,"docs":{"10":{"tf":1.0},"16":{"tf":1.4142135623730951},"28":{"tf":2.23606797749979},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":2.0},"46":{"tf":1.7320508075688772},"5":{"tf":1.0},"53":{"tf":1.7320508075688772},"56":{"tf":1.0},"73":{"tf":1.4142135623730951}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"74":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"64":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":2,"docs":{"5":{"tf":1.0},"6":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"df":0,"docs":{}}},"w":{"df":1,"docs":{"30":{"tf":1.4142135623730951}},"n":{"df":2,"docs":{"53":{"tf":1.0},"62":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"55":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"38":{"tf":1.0},"53":{"tf":1.0}},"i":{"df":2,"docs":{"38":{"tf":1.0},"48":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"46":{"tf":1.0},"76":{"tf":1.0}},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":5,"docs":{"11":{"tf":2.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"3":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}},"k":{"df":1,"docs":{"56":{"tf":1.0}}}},"x":{"df":1,"docs":{"8":{"tf":1.0}}},"z":{"df":0,"docs":{},"e":{"df":2,"docs":{"53":{"tf":1.0},"55":{"tf":1.4142135623730951}}}}},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"19":{"tf":1.0},"69":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"16":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"64":{"tf":1.0}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"25":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"r":{"c":{"df":3,"docs":{"2":{"tf":1.0},"56":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":20,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"4":{"tf":1.7320508075688772},"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"44":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"72":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"48":{"tf":1.0}}}}},":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"66":{"tf":1.4142135623730951}}}}}}}},"df":7,"docs":{"36":{"tf":1.0},"54":{"tf":1.4142135623730951},"60":{"tf":2.0},"62":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":3,"docs":{"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"55":{"tf":2.449489742783178},"70":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":4,"docs":{"17":{"tf":1.0},"21":{"tf":1.0},"58":{"tf":1.0},"69":{"tf":1.0}},"i":{"df":5,"docs":{"36":{"tf":1.0},"53":{"tf":1.7320508075688772},"56":{"tf":1.0},"61":{"tf":1.0},"72":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":2.449489742783178}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"d":{"df":3,"docs":{"21":{"tf":1.7320508075688772},"57":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"r":{"c":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.0}}}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.7320508075688772}}}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}},"r":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":12,"docs":{"19":{"tf":1.0},"27":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"62":{"tf":1.0},"64":{"tf":2.0},"65":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"25":{"tf":1.0}}},"u":{"df":3,"docs":{"11":{"tf":1.0},"42":{"tf":1.0},"73":{"tf":1.0}}}},"y":{"df":1,"docs":{"62":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":3,"docs":{"38":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":2,"docs":{"16":{"tf":1.0},"39":{"tf":1.7320508075688772}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"55":{"tf":1.0},"73":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"53":{"tf":1.0}}},"i":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"76":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"18":{"tf":1.0},"25":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":5,"docs":{"2":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"42":{"tf":1.0},"51":{"tf":1.0},"69":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"40":{"tf":1.0},"56":{"tf":1.0},"76":{"tf":1.0}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"38":{"tf":1.0},"62":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":5,"docs":{"11":{"tf":1.0},"36":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"65":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"72":{"tf":1.4142135623730951},"73":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"52":{"tf":1.0},"72":{"tf":1.0}}}},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}}}},"df":2,"docs":{"19":{"tf":1.0},"30":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"(":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":8,"docs":{"17":{"tf":3.4641016151377544},"19":{"tf":2.23606797749979},"58":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.7320508075688772},"62":{"tf":2.6457513110645907},"66":{"tf":3.872983346207417}},"’":{"df":3,"docs":{"62":{"tf":1.4142135623730951},"66":{"tf":2.0},"67":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"56":{"tf":1.7320508075688772},"62":{"tf":1.0},"8":{"tf":2.0}}}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"51":{"tf":1.0},"61":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":4,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"34":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"’":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"52":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":4,"docs":{"27":{"tf":1.0},"43":{"tf":1.0},"55":{"tf":1.0},"66":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"42":{"tf":1.0},"55":{"tf":1.0},"62":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":3,"docs":{"22":{"tf":1.0},"30":{"tf":1.0},"53":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"69":{"tf":1.0},"76":{"tf":1.0}}}}}}}},"i":{"df":1,"docs":{"62":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":7,"docs":{"18":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}},"r":{"(":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":2.8284271247461903}}}}},"p":{"df":1,"docs":{"70":{"tf":1.7320508075688772}}},"t":{"df":0,"docs":{},"l":{"df":6,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"28":{"tf":1.0},"37":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0}}}}},"l":{"df":3,"docs":{"23":{"tf":1.0},"42":{"tf":1.7320508075688772},"47":{"tf":1.0}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"38":{"tf":1.0},"42":{"tf":1.0}}}},"p":{"df":2,"docs":{"18":{"tf":1.0},"62":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.0},"62":{"tf":1.0}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"o":{"df":8,"docs":{"19":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.4142135623730951}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":5,"docs":{"19":{"tf":2.0},"20":{"tf":1.4142135623730951},"38":{"tf":1.0},"62":{"tf":1.0},"69":{"tf":1.0}}}}}},"u":{"d":{"df":0,"docs":{},"p":{"df":3,"docs":{"22":{"tf":1.0},"40":{"tf":1.0},"72":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":2,"docs":{"30":{"tf":1.0},"34":{"tf":1.0}}},"n":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":1.0},"37":{"tf":1.0},"49":{"tf":1.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"21":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":2,"docs":{"39":{"tf":1.0},"62":{"tf":1.0}}}},"t":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"7":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":4,"docs":{"23":{"tf":1.0},"25":{"tf":1.0},"62":{"tf":1.0},"8":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"51":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}},"df":9,"docs":{"16":{"tf":1.0},"21":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"72":{"tf":1.0}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":21,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"38":{"tf":1.0},"40":{"tf":1.7320508075688772},"41":{"tf":2.23606797749979},"42":{"tf":2.0},"47":{"tf":1.4142135623730951},"5":{"tf":1.0},"52":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.7320508075688772},"67":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"25":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"49":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"21":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"1":{".":{"5":{".":{"0":{"df":2,"docs":{"0":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":3,"docs":{"16":{"tf":1.0},"21":{"tf":1.4142135623730951},"64":{"tf":1.0}}}},"r":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"/":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"56":{"tf":1.0},"69":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"23":{"tf":1.0},"3":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"68":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"16":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"p":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":16,"docs":{"12":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"27":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951}}}},"s":{"d":{"df":2,"docs":{"27":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":8,"docs":{"18":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"48":{"tf":1.0},"56":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"51":{"tf":1.0},"69":{"tf":1.0}}}}}},"b":{"df":1,"docs":{"23":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"39":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"16":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"61":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"14":{"tf":1.0},"67":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"22":{"tf":1.4142135623730951},"39":{"tf":1.0},"45":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"75":{"tf":1.0}},"e":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"i":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"53":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"20":{"tf":1.0},"22":{"tf":1.0},"30":{"tf":1.0},"48":{"tf":1.0}}}}},"df":6,"docs":{"18":{"tf":1.7320508075688772},"36":{"tf":1.0},"61":{"tf":2.0},"62":{"tf":2.8284271247461903},"63":{"tf":1.7320508075688772},"65":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"38":{"tf":1.0},"62":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"42":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}},"’":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"40":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"k":{"df":4,"docs":{"16":{"tf":1.4142135623730951},"37":{"tf":1.0},"39":{"tf":1.0},"73":{"tf":1.0}}},"l":{"d":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":7,"docs":{"27":{"tf":1.0},"53":{"tf":2.23606797749979},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":3,"docs":{"38":{"tf":1.0},"42":{"tf":1.0},"71":{"tf":1.0}}}}}}},"x":{"d":{"df":0,"docs":{},"g":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"60":{"tf":1.0}}},"y":{"df":1,"docs":{"60":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"’":{"df":0,"docs":{},"r":{"df":10,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772},"42":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"v":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"65":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"55":{"tf":1.0},"57":{"tf":2.0},"69":{"tf":1.0}}}},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}}}}},"title":{"root":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":2,"docs":{"54":{"tf":1.0},"7":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"42":{"tf":1.0}}}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"20":{"tf":1.0},"38":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"46":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"36":{"tf":1.0},"51":{"tf":1.0},"69":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"54":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"60":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"53":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"74":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":7,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"35":{"tf":1.0},"4":{"tf":1.0},"47":{"tf":1.0},"72":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"35":{"tf":1.0},"48":{"tf":1.0},"76":{"tf":1.0}}}}}},"i":{"d":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"49":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"45":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"38":{"tf":1.0}}},"k":{"df":1,"docs":{"2":{"tf":1.0}}}}},"o":{"b":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":1,"docs":{"75":{"tf":1.0}}}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.0},"63":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"33":{"tf":1.0},"39":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"12":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"29":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"54":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"44":{"tf":1.0},"45":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":3,"docs":{"43":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"47":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"61":{"tf":1.0},"67":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"22":{"tf":1.0},"23":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":13,"docs":{"33":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}}}}}},"t":{"df":2,"docs":{"28":{"tf":1.0},"46":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"54":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"17":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}}}}},"p":{"df":1,"docs":{"70":{"tf":1.0}}}},"l":{"df":1,"docs":{"42":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"s":{"df":1,"docs":{"42":{"tf":1.0}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}}'));