// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::sync::Arc;

use serde::{Serialize, Deserialize};

use super::colour::Colour;

#[derive(Debug, Default, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Serialize, Deserialize)]
pub struct TeamId(u32);

impl TeamId {
	pub fn from_index(index: usize) -> TeamId {
		TeamId(index as u32)
	}

	pub fn index(self) -> usize {
		self.0 as usize
	}
}

#[derive(Debug, Clone, Serialize, Deserialize)]
pub struct Team {
	name: Arc<str>,
	colour: Colour,
}

impl Team {
	pub fn new(name: Arc<str>, colour: Colour) -> Team {
		Team { name, colour }
	}

	pub fn get_colour(&self) -> Colour {
		self.colour
	}

	pub fn get_name(&self) -> &str {
		&self.name
	}

	#[cfg(feature = "client")]
	pub fn get_name_owned(&self) -> Arc<str> {
		Arc::clone(&self.name)
	}
}
