// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#[cfg(feature = "client")] mod renderer;

#[cfg(feature = "client")] pub use renderer::Renderer as SpecialAreaRenderer;

use glam::Vec2;
use serde::{Serialize, Deserialize};

use super::colour::ColourAlpha;

#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(deny_unknown_fields)] // Used by the server config
pub struct SpecialArea {
	pub pos: Vec2,
	pub size: Vec2,
	pub colour: ColourAlpha,
}
