// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use serde::{Serialize, Deserialize};

use crate::utils::max_len::MaxLenArcStr;
use crate::world::colour::Colour;
#[cfg(feature = "client")] use crate::utils::max_len::{MaxLenStr, MaxLenString};

/**
 * A struct for storing all the ways players can present themselves in the game.
 *
 * Right now players can just choose their name and colour, but in the future I
 * might also allow configuration of the player texture or have multiple colours
 * that can be changed.
 */
#[derive(Debug, Clone, Serialize, Deserialize)]
pub struct PlayerStyle {
	pub name: PlayerName,
	pub colour: Colour,
}

impl PlayerStyle {
	#[cfg(feature = "client")]
	pub fn override_with(mut self, name: Option<PlayerName>, colour: Option<Colour>) -> PlayerStyle {
		if let Some(name) = name { self.name = name; }
		if let Some(colour) = colour { self.colour = colour; }
		self
	}
}

const MAX_NAME_LEN: usize = 100;

#[cfg(feature = "client")] pub type PlayerNameRef<'a> = MaxLenStr<'a, MAX_NAME_LEN>;
pub type PlayerName = MaxLenArcStr<MAX_NAME_LEN>;
#[cfg(feature = "client")] pub type PlayerNameMut = MaxLenString<MAX_NAME_LEN>;
