// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::{fmt::{Display, Formatter, Result as FmtResult}, collections::BTreeMap};

use serde::{Serialize, Deserialize};

#[derive(Debug, Default, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Serialize, Deserialize)]
pub struct PlayerId(u32);

impl PlayerId {
	#[cfg(feature = "client")]
	pub fn next(self) -> PlayerId {
		PlayerId(self.0.wrapping_add(1))
	}

	pub fn find_smallest_unused<T>(map: &BTreeMap<PlayerId, T>) -> PlayerId {
		(0..).map(PlayerId).find(|id| !map.contains_key(id)).unwrap()
	}
}

impl Display for PlayerId {
	fn fmt(&self, fmt: &mut Formatter<'_>) -> FmtResult {
		self.0.fmt(fmt)
	}
}

#[cfg(test)]
impl From<u32> for PlayerId {
	fn from(id: u32) -> PlayerId {
		PlayerId(id)
	}
}
