// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::collections::{BTreeSet, BTreeMap};

mod contains {
	pub trait Contains {
		fn contains(&self, id: u32) -> bool;
	}
}

use contains::Contains;

pub fn find(set: &impl Contains) -> u32 {
}

impl Contains for BTreeSet<u32> {
	fn contains(&self, id: u32) -> bool {
		BTreeSet::contains(self, &id)
	}
}

impl<V> Contains for BTreeMap<u32, V> {
	fn contains(&self, id: u32) -> bool {
		self.contains_key(&id)
	}
}
