// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use serde::{Serialize, de::DeserializeOwned};

use crate::net::message::Message;

pub trait MessageSer: Serialize + Send + 'static {}

pub trait MessageDe: DeserializeOwned + Send + 'static {
	fn into_message(self) -> Message;
}
