// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
mod message;
mod error_container;
mod sender;
mod receiver;

pub use error_container::ErrorContainer;
pub use message::{MessageSer, MessageDe};
pub use sender::SenderTask;
pub use receiver::{ReceiverTask, ReceiverTaskBuilder};

use bincode::{Options, DefaultOptions, ErrorKind as BincodeErrorKind};

const CHANNEL_SIZE: usize = 256;

fn handle_bincode_error(err: Box<BincodeErrorKind>) -> String {
	match *err {
		BincodeErrorKind::SizeLimit => String::from("byte limit reached"),
		BincodeErrorKind::Custom(err) => err,
		_ => format!("{err:?}"),
	}
}

pub(in crate::net) fn bincode_options() -> impl Options {
	DefaultOptions::new()
		.with_little_endian()
		.with_varint_encoding()
}
