// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::net::{SocketAddr, IpAddr, Ipv6Addr};

use quinn::Endpoint;
use bincode::Options;

use super::Info;

use crate::net::{serp::{Request, SIZE_LIMIT, vu30::AsyncReadVu30}, client::Client, message_stream::quic_common};

impl Info {
	#[cfg(feature = "client")]
	#[tokio::main]
	pub async fn request(host: &str, port: u16) -> Result<Info, String> {
		let endpoint = Endpoint::client(SocketAddr::new(IpAddr::V6(Ipv6Addr::UNSPECIFIED), 0)).map_err(|err| format!("cannot create QUIC endpoint: {err}"))?;
		let (connection, _security) = Client::connect(endpoint, host, port).await?;
		let (mut sender, mut receiver) = Request::Info.send(&connection).await.map_err(|err| format!("failed sending request: {err}"))?;
		sender.get_mut().finish().map_err(|err| format!("sender stream aleady closed: {err}"))?;

		let buf = receiver.read_bytes(SIZE_LIMIT).await.map_err(|err| format!("cannot read info: {err}"))?;
		quic_common::bincode_options().with_limit(SIZE_LIMIT as u64).deserialize(&buf).map_err(|err| format!("failed deserialising info: {err}"))
	}
}
