// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use super::{ConnectionListener, IncomingConnection, DynIncomingConnection};

use crate::net::message_stream::{DynMs, singleplayer::LocalMessageStream};
use crate::net::serp::PlayRequest;

pub struct SingleplayerConnectionListener(Option<(SingleplayerIncoming, PlayRequest)>);

impl SingleplayerConnectionListener {
	pub fn new(stream: LocalMessageStream, request: PlayRequest) -> SingleplayerConnectionListener {
		SingleplayerConnectionListener(Some((SingleplayerIncoming(stream), request)))
	}
}

impl ConnectionListener for SingleplayerConnectionListener {
	fn get(&mut self) -> Result<Option<(Box<DynIncomingConnection>, PlayRequest)>, ()> {
		Ok(self.0.take().map(|x| (Box::new(x.0) as Box<DynIncomingConnection>, x.1)))
	}
}

struct SingleplayerIncoming(LocalMessageStream);

impl IncomingConnection for SingleplayerIncoming {
	fn accept(self: Box<Self>) -> Result<Box<DynMs>, (String, String)> { Ok(Box::new(self.0)) }
	fn reject(self: Box<Self>, _reason: String) {}
}
