// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use tokio::sync::mpsc::{Receiver, error::TryRecvError};

use super::{ConnectionListener, DynIncomingConnection, PlayRequest};

use crate::net::message_stream::quic_server::QuicServerMsIncoming;

pub struct NetworkedConnectionListener(Receiver<(QuicServerMsIncoming, PlayRequest)>);

impl NetworkedConnectionListener {
	pub fn new(receiver: Receiver<(QuicServerMsIncoming, PlayRequest)>) -> NetworkedConnectionListener {
		NetworkedConnectionListener(receiver)
	}
}

impl ConnectionListener for NetworkedConnectionListener {
	fn get(&mut self) -> Result<Option<(Box<DynIncomingConnection>, PlayRequest)>, ()> {
		match self.0.try_recv() {
			Ok((incoming, request)) => Ok(Some((Box::new(incoming), request))),
			Err(TryRecvError::Empty) => Ok(None),
			Err(TryRecvError::Disconnected) => Err(()),
		}
	}
}
