// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::env;
use std::path::{Path, PathBuf};

use super::FsBase;

pub struct Filesystem(Box<Path>);

impl Filesystem {
	pub fn build() -> Result<Filesystem, String> {
		let mut path = env::current_exe().map_err(|err| format!("cannot get path of executable: {err}"))?;
		path.pop();
		path.push("data");
		Ok(Filesystem(path.into_boxed_path()))
	}

	pub fn get(&self, _base: FsBase, path: &Path) -> PathBuf {
		self.0.join(path)
	}
}
