// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::path::{Path, PathBuf};

use super::FsBase;

pub struct Filesystem;

/*
 * Need to shut up clippy to prevent warning from code that's perceived to be
 * unnecessary but needed to get shared method signatures between variations of
 * conditional compilation.
 */
impl Filesystem {
	#[allow(clippy::unnecessary_wraps)]
	pub fn build() -> Result<Filesystem, String> { Ok(Filesystem) }

	#[allow(clippy::unused_self)]
	pub fn get(&self, _base: FsBase, path: &Path) -> PathBuf {
		Path::new("data").join(path)
	}
}
