# Server console
When starting the server, you have access to a console that allows addition and removal of game servers, without restarting the entire process. Complete documentation for these particular commands isn't provided here but instead available by running `help` in this console. Instead what is documented here is game ids and basic usage of running multiple game servers on the same process.

When using this console, I recommend redirecting stderr to a file (or /dev/null) to avoid the logs from distracting you as you write your commands.

## Game ids
A spaceships server can run multiple different game servers on the same UDP port. When a player joins the game, the client includes a game id in the request it makes to the server to play the game. The server then takes this id and checks its "routing table" to find a game server the player can join. Game ids are either entered manually when manually entering the address, or automatically with LAN discovery.

The exact mapping of game ids to game servers is up to the server. It is possible to have multiple game ids mapped to the same server.

One game server can be configured to be the default, if it has game id "default". Here, if the user entered a game id that doesn't match any explicit rule in the routing table, the player will join this default server. When you start a server without specifying a game id, it will be configured to be the default server.

## Private servers
Game ids can be used to have the server accessible over the internet but restrict who can join the game by requiring users enter a password. Here, the game id *is* the password. This works because over the internet, it is not possible for clients to gain access to this routing table.

However if the client is on the local network, **by default the game id is exposed locally** and anyone on the local network can find it out by using LAN discovery. If this is a problem, you can completely disable LAN discovery by adding `--lan-discovery disabled` through command line arguments.

## Examples
Here are some examples. Lines beginning with `$` indicate a shell, while lines beginning with `>` indicate the server console.

### Multiple servers
Here is an example of how to host multiple game servers on the same process.

```
$ ./spaceships server maze:configs/maze.ron
> add cave:configs/cave.ron
> add white_noise:configs/white_noise.ron
> route add white_noise noise
> add configs/empty.ron
```

After running all of this, the game ids `maze` and `cave` are mapped to the servers with configs `configs/maze.ron` and `configs/cave.ron` respectively. Game ids `white_noise` and `noise` are mapped to a single server with config `configs/white_noise.ron`. Finally, all other game ids are mapped to `configs/empty.ron` by default.

### Hosting a private server
Here is how to run just a single server only accessible through a hard to guess game id.

```
$ ./spaceships server I-L0v3_sP4c35h1p5:configs/private.ron
```

**Make sure that no colons are present in the password** or the game will instead be accessible at multiple, possibly easier to guess, game ids. To ensure that everything is working fine after starting the server, run `status` and if it prints something like as follows:
```
> status
Showing status for all game servers:
0: {"I-L0v3_sP4c35h1p5"}
   path = configs/private.ron
   player count = 0/8

```

The important part is that only one game id is listed on the third line.
