# Hosting a server
Right now hosting a server is only possible using the command line.

There are many different worlds that you can create, a few of them are provided in the `configs/` directory. These configs are also available [online here](https://codeberg.org/rustydev/spaceships/src/branch/main/configs).

**Tip:** If you're using the Flatpak distribution, configuration files are located in `/app/configs/` inside the sandbox. Whenever you see the `configs/` directory discussed in the rest of the documentation, substitute it for `/app/configs/` if using the Flatpak distribution.

To start a server, simply run `./spaceships server configs/CONFIG.ron`, replacing `configs/CONFIG.ron` with the exact configuration to use. On Windows, you would run `./spaceships.exe server ...`.

The server program outputs logs to the terminal (in particular, stderr), which include information about players joining and leaving the game. The server also provides a simple [REPL interface which allows more advanced configuration](./5-server-console.md).

If you're running an internet server with an associated domain name, if users want to connect to the server by entering the domain name you will need a valid TLS (also called SSL) certificate. To run the server to use this certificate, run `./spaceships ... --cert-path PATH --key-path PATH`, replacing `PATH` with the paths of the certificate and private key. These paths are to files in the PEM format.
