# How to play
## Joining a game
To start a game, you first need to start a server or join an already existing server. See the "Hosting a server" section for more information about starting a server.

If the game server is hosted on the local network, joining the game is done by clicking "Play" and then "Local" under. Then click "Search LAN" and if everything works well, the game server will pop up and you can then click "Play".

If the game server is hosted on the internet (or on the local network but the above instructions don't work for some reason), instead click "Enter Address" and enter the IP address or domain name in the "Host" section. The "Game ID" section can be left blank unless the server administrator tells you to set it to a particular value.

You can also play Spaceships in a singleplayer mode where you can immediately join a local game (where nobody else can join) to test things out. Playing Spaceships only makes sense with other people, it won't be fun at all doing it by yourself (this might change in the future if I create bot players).

## Playing the game
Gameplay in Spaceships involves the player controlling a spaceship that they move around and kill other spaceships by firing bullets at them to diminish their health and eventually destroy them.

### Controls
To move around, use WASD or the arrow keys. To change the direction you're looking in and where bullets will be fired from, move the mouse. Bullets are shot by pressing the left mouse button or spacebar. You can hold down these buttons to easily fire multiple bullets at a time. These controls can be changed by pressing the "Settings" button while in the title screen.

You can zoom the camera in and out by scrolling (or by pressing 'J' and 'K'), and you can reset to the default zoom by pressing the middle mouse button.

If you're playing a game that has flags and you have captured one, you can drop it by pressing 'Q'.

### Health
Your health is displayed in the health bar at the bottom of your screen, with the number of bullets also displayed above that. The health bars of other players are displayed right above them. After getting shot, players slowly regenerate their health.

### Ammo
You have a finite amount of bullets (unless the server is configured to provide you infinite), which are reset when you die. Periodically during the game, ammo crates are spawned which supply the player collecting them with a random amount of bullets.

### Powerups
Additionally, powerups are periodically spawned which give the player collecting them a temporary effect. These effects either last for 30 seconds or happen immediately (teleportation) and are listed as follows:
1. **Speed.** This is the green powerup which increases your movement speed.
2. **Reload.** This is the yellow powerup which increases your reload speed, making you shoot faster.
3. **Health.** This is the pink powerup which increases your health and makes you regenerate health faster. The increase of health that this powerup provides can increase your health above the usual limit and make your health bar blue.
4. **Damage.** This is the red powerup which increases the damage of your bullets.
5. **Forcefield.** This is the blue powerup which provides a forcefield that deflects bullets fired by other players.
6. **Teleportation.** This is the purple powerup which teleports you to a random place on the map. Unlike the others, this can be disadvantageous depending where you teleport...

Here are these six powerups:

![Powerups](images/powerups.webp)

## Exiting a game
To exit the game, press backtick (`).

## Player customisation
The name and colour of the play can be changed by [going into the settings](2-settings.md).

## Teams
Some Spaceships servers can have teams enabled. When you join the game, you will be assigned to a specific team. To change teams, first list the available teams by running the command ([keep reading](#commands) for information about commands) `teams`. This should return a list of teams on the server. Then run `team NAME` where `NAME` is the name of the team you want to change to.

When in a team, your bullets cannot hit other members of your team (unless the server has friendly fire enabled).

## Winning the game
The way the game is actually won, if there is a way, is highly customisable. On the top-left corner of the screen is a list of scores that the server keeps track of. These scores can increase or decrease when certain events happen, such as when a player gets a kill or kills someone else.

Here is a list of a few examples of win conditions that are possible:
* First to N kills.
* Most kills within a certain amount of time.
* Last player remaining where players are eliminated if they lose too many lives.

## Chat
Spaceships has two types of in-game chat that you can use to talk to other players. The first type is team chat which allows you to talk to your team members. To open team chat, press 'T' (you can bind this to something different), start typing and press enter to send your message. Only other players on your team will receive your message, unless teams are disabled in which all players will receive the message.

The second type of chat is global chat which lets you talk to all players. Opening global chat is done by pressing 'G'.

## Commands
Spaceships also supports sending commands to the server using the chat window. To send a command, first press '/' (again, can be rebinded), type your command and then press enter to send it. Run the `help` command to get an exact list of commands the server supports.

Note that opening chat and typing a message beginning with '/' **won't execute a command** and instead send a regular message.

### Underpowering
If you're an experienced player playing with a friend who is new to the game, you can choose to make yourself weaker to make the game fairer. This is called *underpowering* and is done by executing commands.

For an example, to decrease your speed to 75% of what it usually is, run `underpower speed 75%`. Note that you can use 0.75 instead of 75%, and the alias `up` can be used. Another example is to completely disable regeneration, you can run `up regen 0`.

The general syntax for this specific subcommand is `underpower/up EFFECT VALUE`, where `EFFECT` is `speed`, `reload`, `regen` (or `regeneration`) and `damage`, and value is a number or a percentage.

## Security
If you're playing this game online, you might be concerned about whether encryption is used, especially when it comes to chat messages which might be sensitive. Spaceships uses QUIC, a transport-layer protocol over UDP that always uses encryption. However, that doesn't mean that all communications are secure.

First note that the security I'm referring to here is about whether a malicious device on the path between the client and the server can eavesdrop communications. **All chat messages are logged for the server owner to read, so if you don't trust the server owner, don't send any sensitive chat messages.**

While playing the game, the connection's security is displayed in the bottom-left corner under the chat. This information is one of the three security levels, "Secure", "Local" and "Insecure".

### Secure
If a connection is secure, as indicated by the green text saying "Secure connection", it is very unlikely that communication is being eavesdropped.

This level of security is reached when the server is hosted on the same device, or a trusted TLS certificate is used. This level of security is the same as HTTPS on the web.

### Local
If a connection is local, as indicated by the blue text saying "Local connection", it means that the connection isn't secure, *but can only be eavesdropped by an attacker on the local network*. If you're connecting to a server on the local network and you trust that network, communications are secure.

### Insecure
If a connection is insecure, as indicated by the red text saying "INSECURE connection", it means that the connection isn't secure and can be eavesdropped by an attacker on the internet that controls a node on the path. This attacker can be an ISP or a government agency.

For most users, it is unlikely that there actually is an attacker listening into communications, but it is still possible. If you live in an authoritarian regime such as Russia, Saudi Arabia, Myanmar, the United States, Israel, China or Iran, you shouldn't send any chat messages that the government would disapprove of if using an insecure connection. It's better to be safe than sorry.

### Note on eavesdropping
I mentioned earlier that encryption is always enabled in Spaceships. That is true but it is still possible to eavesdrop by performing a [man-in-the-middle attack](https://en.wikipedia.org/wiki/Man-in-the-middle_attack) in which an attacker impersonates the server and can decrypt communications.

This encryption is still better than nothing as it fully prevents against passive eavesdropping attacks, where the attacker can only listen in but can't modify the messages.

## Spectator mode
If you want to watch a game play out but not be an active player, you can join as a spectator. To do this, click the checkbox before starting the game or execute the `spectate` command while playing the game.

While in spectator mode, you can move the camera around using WASD or the arrow keys and you can also drag the camera using the mouse. You can also press 'F' to toggle between freely moving around and following another player in the world.

Some game modes can eliminate the player before the game ends, in which those players will be forcefully put into spectator mode.
