// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#version 330 core

in vec2 v_pos;

in vec2 i_pos;
in float i_alpha;
in uint i_layer;

out vec2 tex_coords_io;
out vec2 cloud_fb_coords_io;
out float alpha_io;
flat out uint layer_io;

uniform vec2 u_size;

void main() {
	gl_Position = vec4((v_pos - 0.5) * u_size + i_pos, 0, 1);
	tex_coords_io = v_pos;
	cloud_fb_coords_io = gl_Position.xy * 0.5 + 0.5;
	alpha_io = i_alpha;
	layer_io = i_layer;
}
