// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#version 330 core

in vec2 v_pos;
in vec2 v_tex_coords;

in vec2 i_pos;
in vec2 i_dir;
in vec3 i_colour;
in float i_brightness;
in float i_alpha;

out vec2 tex_coords_io;
out vec3 colour_io;
out float brightness_io;
out float alpha_io;

uniform mat4 u_matrix;

void main() {
	// Manually did matrix multiplication with i_dir providing the two related coefficients
	vec2 rotated_pos = vec2(v_pos.x * i_dir.x - v_pos.y * i_dir.y, v_pos.x * i_dir.y + v_pos.y * i_dir.x);
	gl_Position = u_matrix * vec4(rotated_pos + i_pos, 0, 1);
	tex_coords_io = v_tex_coords;
	colour_io = i_colour;
	brightness_io = i_brightness;
	alpha_io = i_alpha;
}
