// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#version 330 core

in float alpha_io;
in float grad_io;
in float pulse_io;

out vec4 colour;

void main() {
	float t = pow((sin(pulse_io) + 1) / 2, 48);
	float grad = grad_io * (1 - grad_io) * 4;
	grad *= grad;
	colour = vec4(vec3(0, 0.75, 1), alpha_io * (t * 0.75 + 0.25) * grad);
}
