// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#version 330 core

in vec2 tex_coords_io;
in vec4 colour_io;

out vec4 colour;

uniform sampler2D u_texture;

void main() {
	vec3 tex_colour = texture(u_texture, tex_coords_io).rgb;
	colour = mix(vec4(vec3(tex_colour.r), 1), colour_io, tex_colour.g);
	colour.a *= tex_colour.b;
}
