// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#version 330 core

in vec2 v_pos;
in vec2 v_tex_coords;
in vec3 v_colour;
in float v_alpha;
in vec3 v_temp;

out vec2 tex_coords_io;
out vec3 colour_io;
out float alpha_io;
out vec3 temp_io;

uniform mat4 u_matrix;

void main() {
	gl_Position = u_matrix * vec4(v_pos, 0, 1);
	tex_coords_io = v_tex_coords;
	colour_io = v_colour;
	alpha_io = v_alpha;
	temp_io = v_temp;
}
