// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#version 330 core

in vec2 tex_coords_io;
in vec3 colour_io;
in float alpha_io;
in vec3 temp_io;

out vec4 colour;

uniform sampler2D u_texture;

void main() {
	vec2 tex_colour = texture(u_texture, tex_coords_io).rg;
	colour = vec4(mix(vec3(tex_colour.r), colour_io, tex_colour.g) + temp_io, alpha_io);
}
