// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#version 330 core

in vec2 tex_coords_io;
in vec2 pos_io;
in vec2 radii_io;
flat in uint layer_io;
in float int_io;

out vec4 colour;

uniform sampler2DArray u_texture;
uniform samplerBuffer u_gradient;

void main() {
	vec2 tex_coords = pos_io + radii_io * tex_coords_io;
	vec2 t = texture(u_texture, vec3(tex_coords, layer_io)).rg * int_io; // NOTE: Expecting both components in [0, 1], or the gradient could overflow
	colour = vec4(texelFetch(u_gradient, int(round(t.x * 255))).rgb + texelFetch(u_gradient, 256 + int(round(t.y * 255))).rgb, 1);
}
