// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
#version 330 core

in vec2 pos;
in vec2 grad_pos;
in float grad_type;

out vec2 grad_pos_io;
out float grad_type_io;

uniform mat4 u_matrix;

void main() {
	gl_Position = u_matrix * vec4(pos, 0, 1);
	grad_pos_io = grad_pos;
	grad_type_io = grad_type;
}
