// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use super::inkscape;
use crate::utils;

use png::ColorType;

pub fn generate() {
	const INPUT: &str = "data/bullet.svg";
	const OUTPUT: &str = "../data/textures/bullet.png";

	const SIZE: usize = 64;

	if utils::newer(INPUT, OUTPUT) {
		inkscape::gen_image(INPUT, OUTPUT, SIZE, SIZE, ColorType::Rgba);
	}
}
