// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
mod image;
mod inkscape;
mod layer;

mod player;
mod bullet;
mod block;
mod ammo_status;
mod ammo_crate;
mod powerup;
mod stars;
mod clouds;
mod flag;

use std::fs;

use crate::task::Task;

fn create_dir() {
	// Prevents erroring when already created
	let _ = fs::create_dir("../data/textures");
}

pub fn get_tasks(tasks: &mut Vec<Task>) {
	tasks.extend_from_slice(&[
		Task::new("Creating texture directory", create_dir),
		Task::new("Generating player texture", player::generate),
		Task::new("Generating bullet texture", bullet::generate),
		Task::new("Generating block texture", block::generate),
		Task::new("Generating ammo status texture", ammo_status::generate),
		Task::new("Generating ammo crate texture", ammo_crate::generate),
		Task::new("Generating powerup textures", powerup::generate),
		Task::new("Generating star textures", stars::generate),
		Task::new("Generating cloud textueres", clouds::generate),
		Task::new("Generating flag textuere", flag::generate),
	]);
}

pub use player::generate_icon;
