// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
pub trait Waves {
	fn smooth_square(self, t: f32) -> f32;
}

impl Waves for f32 {
	fn smooth_square(self, smoothness: f32) -> f32 {
		let sine = self.sin();
		sine.abs().powf(smoothness) * sine.signum()
	}
}
