// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::array;

use super::{DELTA_TIME, chirp::ExponentialChirp, sampler::BrownianNoise, resampler::{Resampler, SmoothstepResampler}};

const AMPLITUDE: f32 = 0.5;
const TIME: f32 = 0.625;
const FADE_IN: f32 = TIME / 32.0;

pub fn generate() {
	let mut chirps: [_; 4] = array::from_fn(|i| {
		let mul = 1.0 + i as f32 * 0.09375;
		(ExponentialChirp::new(5000.0 * mul, 100.0 * mul, TIME), SmoothstepResampler::new(BrownianNoise::new(0.25, 92840127 + i as u64)))
	});

	super::generate("../data/sounds/teleportation.wav", TIME, AMPLITUDE, |t| {
		let mut wave = 0.0;
		for (i, (chirp, noise)) in chirps.iter_mut().enumerate() {
			wave += chirp.get(t, 0.5) / (i as f32 + 1.0).powf(1.5) * noise.next(2500.0 * DELTA_TIME);
		}

		let mut amplitude = 1.0 - (1.0 - (t / FADE_IN).min(1.0)).powi(2); // Fade in
		amplitude *= 1.0 - t / TIME; // Fade out
		wave * amplitude
	});
}
