// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use super::shot::{self, TIME as SHOT_TIME};

const AMPLITUDE: f32 = 0.5;
const TIME: f32 = 0.5;
const FADE_IN: f32 = TIME / 16.0;
const SHOT_COUNT: usize = 8;
const SHOT_TIME_MUL: f32 = 2.0;

pub fn generate() {
	super::generate("../data/sounds/reload.wav", TIME, AMPLITUDE, |t| {
		let mut shot_t = t / TIME * SHOT_COUNT as f32;
		let mut shot_i = shot_t.floor();
		shot_t -= shot_i;

		let mut wave = 0.0;

		#[allow(clippy::while_float)]
		while shot_t < SHOT_TIME_MUL {
			let freq_mul = if shot_i as u32 % 2 == 0 { 1.375 } else { 1.5 };
			let t = shot_t * SHOT_TIME;
			wave += shot::wave(t, freq_mul) * shot::envelope(t / SHOT_TIME_MUL);
			shot_i += 1.0;
			shot_t += 1.0;
		}

		let mut amplitude = 1.0 - (t / TIME).powi(2); // Fade out
		amplitude *= 1.0 - (1.0 - (t / FADE_IN).min(1.0)).powi(2); // Fade in
		wave * amplitude
	});
}
