// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::f32::consts::TAU;

use super::waves::Waves;

const AMPLITUDE: f32 = 0.5;
const TIME: f32 = 0.5;
const FADE_IN: f32 = TIME / 64.0;

pub fn generate() {
	super::generate("../data/sounds/game_start.wav", TIME, AMPLITUDE, |t| {
		let mut wave = 0.0;
		for i in 0..4 {
			let freq = 800.0 * (i as f32 * 1.0 + 1.0);
			let amplitude = (1.0 - t / TIME).powf(5.0 - i as f32 * 0.75) / (i as f32 + 1.0).powi(3);
			wave += (t * freq * TAU).smooth_square(0.75 + i as f32 * 0.25) * amplitude;
		}

		let amplitude = 1.0 - (1.0 - (t / FADE_IN).min(1.0)).powi(2); // Fade in
		wave * amplitude
	});
}
