// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::f32::consts::TAU;

use super::waves::Waves;

pub struct ExponentialChirp {
	s: f32,
	k: f32,
}

impl ExponentialChirp {
	pub fn new(f0: f32, f1: f32, time: f32) -> ExponentialChirp {
		let k = (f1 / f0).ln() / time;
		ExponentialChirp { s: TAU * f0 / k, k }
	}

	pub fn get(&self, t: f32, smoothness: f32) -> f32 {
		(self.s * (self.k * t).exp()).smooth_square(smoothness)
	}
}
