// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::array;

use super::{DELTA_TIME, sampler::WhiteNoise, resampler::{Resampler, SmoothstepResampler}};

const AMPLITUDE: f32 = 0.109375;
const TIME: f32 = 2.5;

pub fn generate() {
	let mut noises: [_; 16] = array::from_fn(|i| SmoothstepResampler::new(WhiteNoise::new(48912797 + i as u64)));
	let mut amplitude_noise = SmoothstepResampler::new(WhiteNoise::new(248107890));

	super::generate("../data/sounds/block_player.wav", TIME, AMPLITUDE, |_t| {
		let mut wave = 0.0;
		for (i, noise) in noises.iter_mut().enumerate() {
			let freq = 1250.0 * (i + 1) as f32;
			let amplitude = 1.0 / (i as f32 * 0.5 + 1.0).powf(1.5);
			let w = noise.next(freq * DELTA_TIME).powi(3);
			wave += w * amplitude;
		}

		let amplitude = amplitude_noise.next(1600.0 * DELTA_TIME) * 0.25 + 0.75;
		wave * amplitude
	}).loopable();
}
