// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
mod textures;
mod sounds;
mod explosion;
mod utils;
mod task;

use std::{env, process};

use task::Task;

fn main() {
	let mut args = env::args().skip(1);

	match args.next().as_deref() {
		Some("icon") => {
			let Some((size, out_path)) = args.next().and_then(|size| size.parse().ok()).zip(args.next()) else {
				eprintln!("expected size and output path");
				process::exit(1);
			};

			textures::generate_icon(size, &out_path);
		},
		Some(x) => {
			eprintln!("invalid argument \"{x}\"");
			process::exit(1);
		},
		None => {
			let mut tasks = Vec::new();
			textures::get_tasks(&mut tasks);
			sounds::get_tasks(&mut tasks);
			tasks.push(Task::new("Generating explosion data", explosion::generate));

			let task_count_string = tasks.len().to_string();
			for (i, task) in tasks.into_iter().enumerate() {
				task.run(i, &task_count_string);
			}
		}
	}
}
