// Copyright Marcus Del Favero 2025
// Licensed under the GNU AGPLv3 with an exception, see `README.md` for details
use std::cmp::Ordering;

use glam::Vec2;

#[derive(Clone)]
pub struct Edge(pub Vec2, pub Vec2);

impl PartialEq for Edge {
	fn eq(&self, other: &Edge) -> bool {
		(self.0 == other.0 && self.1 == other.1) ||
		(self.0 == other.1 && self.1 == other.0)
	}
}

impl Eq for Edge {}

impl Ord for Edge {
	fn cmp(&self, other: &Edge) -> Ordering {
		self.0.x.total_cmp(&other.0.x)
			.then(self.0.y.total_cmp(&other.0.y))
			.then(self.1.x.total_cmp(&other.1.x))
			.then(self.1.y.total_cmp(&other.1.y))
	}
}

impl PartialOrd for Edge {
	fn partial_cmp(&self, other: &Edge) -> Option<Ordering> {
		Some(self.cmp(other))
	}
}
