# Spaceships
Spaceships is a [free-as-in-freedom](https://www.gnu.org/philosophy/free-sw.html) multiplayer game that's written in Rust and created by Marcus Del Favero. Note that this game is currently in **heavy development**, and isn't the most user-friendly.

## Links
* Website: <https://spaceships.me>
* Download: <https://spaceships.me/download>
* Documentation: <https://spaceships.me/docs>
* Source code: <https://codeberg.org/rustydev/spaceships>
* Lemmy: <https://lemmy.spaceships.me>
	* Development blog: <https://lemmy.spaceships.me/c/blog>
	* Help and support: <https://lemmy.spaceships.me/c/help>
* Matrix: [#spaceships:matrix.spaceships.me](https://matrix.to/#/#spaceships:matrix.spaceships.me)
	* Chat: [#chat:matrix.spaceships.me](https://matrix.to/#/#chat:matrix.spaceships.me)
	* Help and support: [#help:matrix.spaceships.me](https://matrix.to/#/#help:matrix.spaceships.me)
* PeerTube: <https://peertube.spaceships.me>

## Screenshots
![Red player shooting at blue player.](docs/src/images/game1.webp)
![Orange player shooting at green player that has forcefield, with the bullets deflecting.](docs/src/images/game2.webp)
![White player exploring with custom sky preset (Galaxy) shown.](docs/src/images/game3.webp)

# Installation
This game is available on both Linux (including Flatpak) and Windows. It might also be possible to compile to macOS but I haven't yet tested it. Go to <https://spaceships.me/download> to download a copy or get instructions to getting the Flatpak. You can also build from source.

# Building
Here is some information about building the game.

## Features
This project has three Cargo features, `client`, `standalone` and `flatpak`, with just `client` being enabled by default.
* `client`: This builds the game client as well as the game server. If you want to create a server-only build (which can save disk space if you're just interested in running a server), disable this feature by running `cargo build --release --no-default-features` at step 3. If you do disable this feature, you can skip the first step of building the assets during compilation.
* `standalone`: This is disabled by default but is enabled when building standalone releases. When this flag is set, the path to the `data/` directory (which stores all assets used by the client) is based on the path of the Spaceships executable. This makes it convenient to play the game as a regular user as you don't need to worry about the current working directory being correct. However this is annoying during development as the binary is located in `target/debug/` or `target/release/`, which would expect the `data/` directory to be in this target directory, so it is disabled by default. To build using this flag, run `cargo build --release -F standalone` when at step 3.
* `flatpak`: This is enabled when building [Flatpak](https://spaceships.me/download/#flatpak) releases. When this flag is set, the path to the `data/` directory is set to `/app/data/` or `$XDG_CONFIG_HOME` for `config.ron`.

## Steps
Here are the steps necessary to build the game. You can also run `dist.sh` to automatically do this, but I recommend manually building it, as building takes a long time and you are probably interested in it for one operating system. Also if you're not using x86\_64, the build script won't work. **If you're cloning the repository, make sure you checkout the correct version!**
1. **Download the latest version of Rust.** I recommend installing Rust through [`rustup`](https://www.rust-lang.org/learn/get-started), which allows updating it by running `rustup update`. If you're using Arch Linux, an alternative is using the distribution's `rust` package.
2. **Build the assets.** Most assets used in this game are SVG files located in `assets/data/`, with an exception for the powerup textures and explosion effects (not an image) which are procedurally generated. These assets must be generated/converted to PNGs during the build process. To do this, go into the `assets` directory and then run `cargo run --release`. This will take a few seconds. **Note that this won't work on Windows due to lazy programming on my part (writing temporary files to /tmp) and requires installing Inkscape.** If you want to skip this step, you can instead download a binary release of this game and copy the files from `data/textures/` and `data/explosions`.
3. **Build the game.** Now the game can be built by running `cargo build --release`. **This will take a few minutes when compiling for the first time!**

# Licensing and contributing
**Spaceships is free software**, released under the GNU AGPLv3 license (but not at any later versions) with an exception that is explained later. If you contribute to this project, you own the copyright of your changes (no [CLA bullshit](https://en.wikipedia.org/wiki/Contributor_License_Agreement#Relicensing_controversy) here) but you must release your work under a software license compatible with the GNU AGPLv3 with this provided exception.

The contents of the GNU AGPLv3 license is provided in the attached `LICENSE` file and also [available online](https://www.gnu.org/licenses/agpl-3.0.en.html).

## Fonts used
This game uses the [Inter](https://rsms.me/inter) (stored at `data/fonts/inter.otf`) and [Press Start 2P](https://www.zone38.net/font/#pressstart) (stored at `data/fonts/press_start_2p.ttf`), both of which are released under the SIL Open Font License version 1.1. The license and copyright details are available in `data/fonts/inter.otf.license` and `data/fonts/press_start_2p.ttf.license` for the respective fonts. The exact variant of Inter used is Inter-Medium.otf modified with the tnum feature to be enabled (fixed width for all numbers). This is achieved by running `pyftfeatfreeze -f tnum old.otf new.otf`.

## Dependencies
Software licensing is a pain in the arse, especially when the project has hundreds of transitive dependencies (dependencies of dependencies) which is the case here in the Rust ecosystem. Luckily there exists the [cargo deny](https://github.com/EmbarkStudios/cargo-deny) Cargo plugin which automatically checks the licenses of all dependencies used. The dependencies that this project uses are listed in the `Cargo.lock` file in the source distribution of this project.

Running `cargo deny check licenses` in this project with the provided `deny.toml` file shows that everything's fine when it comes to licensing. Read the comments in `deny.toml` explaining why each things are fine, with more details on the OpenSSL license situation below.

Two of this project's transitive dependencies are `aws-lc-sys` and `ring`. Both of these are released under the OpenSSL license and many other permissive free software licenses. A problem with the OpenSSL license is that it is incompatible with the GNU GPL licenses. However, it is [still possible to use incompatible libraries](https://www.gnu.org/licenses/gpl-faq.en.html#GPLIncompatibleLibs) *as long as* the copyright holder chooses to provide an exception to allow these. Luckily I am the copyright holder and none of my dependencies use a GPL license so I can freely add such an exception.

Hopefully in the future this licensing problem will completely go away. The developer of `ring` [hopes this will be the case sometime](https://github.com/briansmith/ring/issues/1827), and I wish them the best of luck in doing so. I can completely replace `aws-lc-rs` with `ring` if I want to, in case `aws-lc-rs` doesn't change.

Here is this exception, which I created by cutting and modifying pieces of [this text from GNU's page about incompatible licenses](https://www.gnu.org/licenses/gpl-faq.en.html#GPLIncompatibleLibs) and [this text here](https://git.deluge-torrent.org/deluge/plain/LICENSE) at the beginning of Deluge's license.

## OpenSSL exception
Additional permission under GNU AGPLv3 section 7:

In addition, as a special exception, the copyright holder(s) give permission to link the code of portions of this program with any code released under the OpenSSL License that is either a part of OpenSSL or has originated from OpenSSL (which is including but not limited to the `ring` and `aws-lc-sys` crates that are found at https://crates.io). If you redistribute this project (either identical or modified copies), you are allowed to keep this exact same OpenSSL exception or remove it (in which the license would be identical to the unmodified GNU AGPLv3).

# Forking
**If you're forking this project, please modify the details in `Cargo.toml` to allow users requesting information about the server (see the "Requesting server info" section for more information) to know where to obtain a copy of the source code.**
