Here's a checklist of my immediate plans for the future. If you have an idea for a feature, feel free to make an issue.

# v1.4.0
* [x] Refactor.
	* [x] D* -> BTree*.
	* [x] Use `libm` flag in `glam`.
	* [x] Remove `maths::rotate_by`, `maths::rotate_by_dir`, and `maths::angle_to_dir`, using the alternatives in `glam`.
	* [x] PlayerColour -> Colour.
	* [x] Split up `net/server/config.rs`.
* [x] Update dependencies.
* [x] Add extension data to protocol.
* [x] Play teleportation sounds when teleporting with portals.
	* [x] Have `PlayerPos` events indicate the type of teleportation.
	* [x] Play the sound.
* [x] Initial message extension data.
* [x] Capture the flag.
	* [x] Create the flag's graphics.
		* [x] Create a simple SVG.
		* [x] Write code to export it.
		* [x] Render it to the world using correct colours.
		* [x] Improve the flag.
	* [x] Get simple static flags working in the world.
		* [x] Add flags to the world.
		* [x] Add flags to server config.
		* [x] Add an alpha channel to the colour and allow it to be configured.
			* [x] Also use the new RGBA struct for special areas.
	* [x] Allow players to capture flags.
		* [x] Create the `FlagState` enum and world event.
		* [x] Write server-side code to capture flags.
		* [x] Render flags as being captured.
		* [x] Prevent players from capturing multiple flags at a time.
		* [x] Drop flags when players die or leave.
		* [x] Reset all flags when the game resets.
		* [x] Have the flag smoothly animate to the player's centre while being captured.
			* [x] Get started.
			* [x] Improve the animation.
			* [x] Take the time shift into account.
	* [x] Allow players to drop flags they've captured.
		* [x] Add drop input binding to config.
		* [x] Add drop input to protocol.
		* [x] Drop the flag when a flag is held and this input is pressed down.
		* [x] Prevent it from being picked up immediately after.
	* [x] Improve how flags are captured when multiple players are colliding with it.
		A random player should be chosen, with bias for players on the flag's team.
	* [x] Gameplay.
		* [x] Prevent players picking up their own team's flags if they're at their default position.
		* [x] Create team bases.
		* [x] Return flags to their default position when they collide with the current team's base.
			This happens whenever the flag is fixed, or following a player but the player belongs to that team.
		* [x] Return flags to their default position when they collide with an opposing team's base.
	* [x] Scoring.
		* [x] Refactor.
		* [x] Create score event and listener.
		* [x] Actually use the listener and change the score.
	* [x] Create a config.
* [x] Move flag origin to centre of flagpole and change hitbox.
* [x] Change forcefield strength distribution to more accurately model the animation.
* [x] Team changes.
	* [x] Prevent the possibility of changing teams when spectating and replaying.
	* [x] Have the `teams` command show your current team even when spectating.
* [x] Sound effects for game state transitions.
	* [x] Game started.
		* [x] Create basic sound.
		* [x] Extend protocol and send message hinting when to play it.
		* [x] Play the sound.
		* [x] Improve it.
	* [x] Game end.
		* [x] Create basic sounds.
		* [x] Update the protocol and play the sounds.
		* [x] Improve the sounds.
			* [x] Neutral.
			* [x] Win.
* [ ] ~Decrease the amplitude of all sounds to reduce the chances of clipping.~
	Not needed, `kira` seems to do a good job at preventing clipping.
* [x] More sound effects.
	* [x] Capturing/dropping a flag.
		* [x] Play these sounds.
		* [x] Start creating the sounds. Will have slight variation between these sounds.
		* [x] Improve them.
			* [x] Capturing.
			* [x] Dropping.
	* [ ] ~Returning an opposing team's flag.~
	* [ ] ~Returning your team's flag.~
		Both these sounds can use the flag drop sound.
	* [x] Play flag drop sounds where the dropping player last was.
* [x] Avoid playing effect sounds when increasing the underpowering.
* [x] Remove `test.ron`.
* [x] Update documentation.
	* [x] New screenshots.
	* [x] Examples of capture the flag.
	* [x] Check that all server configs work.
* [x] Fix permissions with Flatpak distribution.
* [x] Update SERP version.

# v1.4.1
* [ ] Fix bug with many textures (bullets, ammo crates, powerups, probably more) being upside down.
	Want to also flip the output textures to keep things looking the same.
